/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gameliftstreams.model.ArnListCopier;
import software.amazon.awssdk.services.gameliftstreams.model.DefaultApplication;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.LocationState;
import software.amazon.awssdk.services.gameliftstreams.model.LocationStatesCopier;
import software.amazon.awssdk.services.gameliftstreams.model.StreamClass;
import software.amazon.awssdk.services.gameliftstreams.model.StreamGroupStatus;
import software.amazon.awssdk.services.gameliftstreams.model.StreamGroupStatusReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStreamGroupResponse
extends GameLiftStreamsResponse
implements ToCopyableBuilder<Builder, GetStreamGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::arn)).setter(GetStreamGroupResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedApplications").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::associatedApplications)).setter(GetStreamGroupResponse.setter(Builder::associatedApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::createdAt)).setter(GetStreamGroupResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<DefaultApplication> DEFAULT_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultApplication").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::defaultApplication)).setter(GetStreamGroupResponse.setter(Builder::defaultApplication)).constructor(DefaultApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultApplication").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::description)).setter(GetStreamGroupResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::id)).setter(GetStreamGroupResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::lastUpdatedAt)).setter(GetStreamGroupResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<List<LocationState>> LOCATION_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocationStates").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::locationStates)).setter(GetStreamGroupResponse.setter(Builder::locationStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::statusAsString)).setter(GetStreamGroupResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::statusReasonAsString)).setter(GetStreamGroupResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> STREAM_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamClass").getter(GetStreamGroupResponse.getter(GetStreamGroupResponse::streamClassAsString)).setter(GetStreamGroupResponse.setter(Builder::streamClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ASSOCIATED_APPLICATIONS_FIELD, CREATED_AT_FIELD, DEFAULT_APPLICATION_FIELD, DESCRIPTION_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, LOCATION_STATES_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, STREAM_CLASS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetStreamGroupResponse.memberNameToFieldInitializer();
    private final String arn;
    private final List<String> associatedApplications;
    private final Instant createdAt;
    private final DefaultApplication defaultApplication;
    private final String description;
    private final String id;
    private final Instant lastUpdatedAt;
    private final List<LocationState> locationStates;
    private final String status;
    private final String statusReason;
    private final String streamClass;

    private GetStreamGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.associatedApplications = builder.associatedApplications;
        this.createdAt = builder.createdAt;
        this.defaultApplication = builder.defaultApplication;
        this.description = builder.description;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.locationStates = builder.locationStates;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.streamClass = builder.streamClass;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAssociatedApplications() {
        return this.associatedApplications != null && !(this.associatedApplications instanceof SdkAutoConstructList);
    }

    public final List<String> associatedApplications() {
        return this.associatedApplications;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DefaultApplication defaultApplication() {
        return this.defaultApplication;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasLocationStates() {
        return this.locationStates != null && !(this.locationStates instanceof SdkAutoConstructList);
    }

    public final List<LocationState> locationStates() {
        return this.locationStates;
    }

    public final StreamGroupStatus status() {
        return StreamGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StreamGroupStatusReason statusReason() {
        return StreamGroupStatusReason.fromValue(this.statusReason);
    }

    public final String statusReasonAsString() {
        return this.statusReason;
    }

    public final StreamClass streamClass() {
        return StreamClass.fromValue(this.streamClass);
    }

    public final String streamClassAsString() {
        return this.streamClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedApplications() ? this.associatedApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultApplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationStates() ? this.locationStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamClassAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamGroupResponse)) {
            return false;
        }
        GetStreamGroupResponse other = (GetStreamGroupResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasAssociatedApplications() == other.hasAssociatedApplications() && Objects.equals(this.associatedApplications(), other.associatedApplications()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.defaultApplication(), other.defaultApplication()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasLocationStates() == other.hasLocationStates() && Objects.equals(this.locationStates(), other.locationStates()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReasonAsString(), other.statusReasonAsString()) && Objects.equals(this.streamClassAsString(), other.streamClassAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetStreamGroupResponse").add("Arn", (Object)this.arn()).add("AssociatedApplications", this.hasAssociatedApplications() ? this.associatedApplications() : null).add("CreatedAt", (Object)this.createdAt()).add("DefaultApplication", (Object)this.defaultApplication()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LocationStates", this.hasLocationStates() ? this.locationStates() : null).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReasonAsString()).add("StreamClass", (Object)this.streamClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AssociatedApplications": {
                return Optional.ofNullable(clazz.cast(this.associatedApplications()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DefaultApplication": {
                return Optional.ofNullable(clazz.cast(this.defaultApplication()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "LocationStates": {
                return Optional.ofNullable(clazz.cast(this.locationStates()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReasonAsString()));
            }
            case "StreamClass": {
                return Optional.ofNullable(clazz.cast(this.streamClassAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("AssociatedApplications", ASSOCIATED_APPLICATIONS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("DefaultApplication", DEFAULT_APPLICATION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("LocationStates", LOCATION_STATES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("StreamClass", STREAM_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStreamGroupResponse, T> g) {
        return obj -> g.apply((GetStreamGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> associatedApplications = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private DefaultApplication defaultApplication;
        private String description;
        private String id;
        private Instant lastUpdatedAt;
        private List<LocationState> locationStates = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusReason;
        private String streamClass;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamGroupResponse model) {
            super(model);
            this.arn(model.arn);
            this.associatedApplications(model.associatedApplications);
            this.createdAt(model.createdAt);
            this.defaultApplication(model.defaultApplication);
            this.description(model.description);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.locationStates(model.locationStates);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.streamClass(model.streamClass);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAssociatedApplications() {
            if (this.associatedApplications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedApplications;
        }

        public final void setAssociatedApplications(Collection<String> associatedApplications) {
            this.associatedApplications = ArnListCopier.copy(associatedApplications);
        }

        @Override
        public final Builder associatedApplications(Collection<String> associatedApplications) {
            this.associatedApplications = ArnListCopier.copy(associatedApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedApplications(String ... associatedApplications) {
            this.associatedApplications(Arrays.asList(associatedApplications));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final DefaultApplication.Builder getDefaultApplication() {
            return this.defaultApplication != null ? this.defaultApplication.toBuilder() : null;
        }

        public final void setDefaultApplication(DefaultApplication.BuilderImpl defaultApplication) {
            this.defaultApplication = defaultApplication != null ? defaultApplication.build() : null;
        }

        @Override
        public final Builder defaultApplication(DefaultApplication defaultApplication) {
            this.defaultApplication = defaultApplication;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final List<LocationState.Builder> getLocationStates() {
            List<LocationState.Builder> result = LocationStatesCopier.copyToBuilder(this.locationStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationStates(Collection<LocationState.BuilderImpl> locationStates) {
            this.locationStates = LocationStatesCopier.copyFromBuilder(locationStates);
        }

        @Override
        public final Builder locationStates(Collection<LocationState> locationStates) {
            this.locationStates = LocationStatesCopier.copy(locationStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationStates(LocationState ... locationStates) {
            this.locationStates(Arrays.asList(locationStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationStates(Consumer<LocationState.Builder> ... locationStates) {
            this.locationStates(Stream.of(locationStates).map(c -> (LocationState)((LocationState.Builder)LocationState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(StreamGroupStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final String getStreamClass() {
            return this.streamClass;
        }

        public final void setStreamClass(String streamClass) {
            this.streamClass = streamClass;
        }

        @Override
        public final Builder streamClass(String streamClass) {
            this.streamClass = streamClass;
            return this;
        }

        @Override
        public final Builder streamClass(StreamClass streamClass) {
            this.streamClass(streamClass == null ? null : streamClass.toString());
            return this;
        }

        @Override
        public GetStreamGroupResponse build() {
            return new GetStreamGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftStreamsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStreamGroupResponse> {
        public Builder arn(String var1);

        public Builder associatedApplications(Collection<String> var1);

        public Builder associatedApplications(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder defaultApplication(DefaultApplication var1);

        default public Builder defaultApplication(Consumer<DefaultApplication.Builder> defaultApplication) {
            return this.defaultApplication((DefaultApplication)((DefaultApplication.Builder)DefaultApplication.builder().applyMutation(defaultApplication)).build());
        }

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder locationStates(Collection<LocationState> var1);

        public Builder locationStates(LocationState ... var1);

        public Builder locationStates(Consumer<LocationState.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(StreamGroupStatus var1);

        public Builder statusReason(String var1);

        public Builder statusReason(StreamGroupStatusReason var1);

        public Builder streamClass(String var1);

        public Builder streamClass(StreamClass var1);
    }
}

