/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.gameliftstreams.GameLiftStreamsClient;
import software.amazon.awssdk.services.gameliftstreams.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetApplicationRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetApplicationResponse;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamGroupRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamGroupResponse;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamSessionRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamSessionResponse;
import software.amazon.awssdk.services.gameliftstreams.waiters.GameLiftStreamsWaiter;
import software.amazon.awssdk.services.gameliftstreams.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultGameLiftStreamsWaiter
implements GameLiftStreamsWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final GameLiftStreamsClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetApplicationResponse> applicationDeletedWaiter;
    private final Waiter<GetApplicationResponse> applicationReadyWaiter;
    private final Waiter<GetStreamGroupResponse> streamGroupActiveWaiter;
    private final Waiter<GetStreamGroupResponse> streamGroupDeletedWaiter;
    private final Waiter<GetStreamSessionResponse> streamSessionActiveWaiter;

    private DefaultGameLiftStreamsWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (GameLiftStreamsClient)GameLiftStreamsClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.applicationDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetApplicationResponse.class).acceptors(DefaultGameLiftStreamsWaiter.applicationDeletedWaiterAcceptors())).overrideConfiguration(DefaultGameLiftStreamsWaiter.applicationDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.applicationReadyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetApplicationResponse.class).acceptors(DefaultGameLiftStreamsWaiter.applicationReadyWaiterAcceptors())).overrideConfiguration(DefaultGameLiftStreamsWaiter.applicationReadyWaiterConfig(builder.overrideConfiguration))).build();
        this.streamGroupActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStreamGroupResponse.class).acceptors(DefaultGameLiftStreamsWaiter.streamGroupActiveWaiterAcceptors())).overrideConfiguration(DefaultGameLiftStreamsWaiter.streamGroupActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.streamGroupDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStreamGroupResponse.class).acceptors(DefaultGameLiftStreamsWaiter.streamGroupDeletedWaiterAcceptors())).overrideConfiguration(DefaultGameLiftStreamsWaiter.streamGroupDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.streamSessionActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStreamSessionResponse.class).acceptors(DefaultGameLiftStreamsWaiter.streamSessionActiveWaiterAcceptors())).overrideConfiguration(DefaultGameLiftStreamsWaiter.streamSessionActiveWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetApplicationResponse> waitUntilApplicationDeleted(GetApplicationRequest getApplicationRequest) {
        return this.applicationDeletedWaiter.run(() -> this.client.getApplication(this.applyWaitersUserAgent(getApplicationRequest)));
    }

    @Override
    public WaiterResponse<GetApplicationResponse> waitUntilApplicationDeleted(GetApplicationRequest getApplicationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.applicationDeletedWaiter.run(() -> this.client.getApplication(this.applyWaitersUserAgent(getApplicationRequest)), DefaultGameLiftStreamsWaiter.applicationDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetApplicationResponse> waitUntilApplicationReady(GetApplicationRequest getApplicationRequest) {
        return this.applicationReadyWaiter.run(() -> this.client.getApplication(this.applyWaitersUserAgent(getApplicationRequest)));
    }

    @Override
    public WaiterResponse<GetApplicationResponse> waitUntilApplicationReady(GetApplicationRequest getApplicationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.applicationReadyWaiter.run(() -> this.client.getApplication(this.applyWaitersUserAgent(getApplicationRequest)), DefaultGameLiftStreamsWaiter.applicationReadyWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStreamGroupResponse> waitUntilStreamGroupActive(GetStreamGroupRequest getStreamGroupRequest) {
        return this.streamGroupActiveWaiter.run(() -> this.client.getStreamGroup(this.applyWaitersUserAgent(getStreamGroupRequest)));
    }

    @Override
    public WaiterResponse<GetStreamGroupResponse> waitUntilStreamGroupActive(GetStreamGroupRequest getStreamGroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamGroupActiveWaiter.run(() -> this.client.getStreamGroup(this.applyWaitersUserAgent(getStreamGroupRequest)), DefaultGameLiftStreamsWaiter.streamGroupActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStreamGroupResponse> waitUntilStreamGroupDeleted(GetStreamGroupRequest getStreamGroupRequest) {
        return this.streamGroupDeletedWaiter.run(() -> this.client.getStreamGroup(this.applyWaitersUserAgent(getStreamGroupRequest)));
    }

    @Override
    public WaiterResponse<GetStreamGroupResponse> waitUntilStreamGroupDeleted(GetStreamGroupRequest getStreamGroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamGroupDeletedWaiter.run(() -> this.client.getStreamGroup(this.applyWaitersUserAgent(getStreamGroupRequest)), DefaultGameLiftStreamsWaiter.streamGroupDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStreamSessionResponse> waitUntilStreamSessionActive(GetStreamSessionRequest getStreamSessionRequest) {
        return this.streamSessionActiveWaiter.run(() -> this.client.getStreamSession(this.applyWaitersUserAgent(getStreamSessionRequest)));
    }

    @Override
    public WaiterResponse<GetStreamSessionResponse> waitUntilStreamSessionActive(GetStreamSessionRequest getStreamSessionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamSessionActiveWaiter.run(() -> this.client.getStreamSession(this.applyWaitersUserAgent(getStreamSessionRequest)), DefaultGameLiftStreamsWaiter.streamSessionActiveWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetApplicationResponse>> applicationDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetApplicationResponse>> result = new ArrayList<WaiterAcceptor<? super GetApplicationResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultGameLiftStreamsWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetApplicationResponse>> applicationReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetApplicationResponse>> result = new ArrayList<WaiterAcceptor<? super GetApplicationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamGroupResponse>> streamGroupActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamGroupResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamGroupResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=ERROR) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ACTIVE_WITH_ERRORS");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=ACTIVE_WITH_ERRORS) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "DELETING");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=DELETING) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamGroupResponse>> streamGroupDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamGroupResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamGroupResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultGameLiftStreamsWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamSessionResponse>> streamSessionActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamSessionResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamSessionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration applicationDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration applicationReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamGroupActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamGroupDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamSessionActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static GameLiftStreamsWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends GameLiftStreamsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((GameLiftStreamsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements GameLiftStreamsWaiter.Builder {
        private GameLiftStreamsClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public GameLiftStreamsWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public GameLiftStreamsWaiter.Builder client(GameLiftStreamsClient client) {
            this.client = client;
            return this;
        }

        @Override
        public GameLiftStreamsWaiter build() {
            return new DefaultGameLiftStreamsWaiter(this);
        }
    }
}

