/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gameliftstreams.model.StreamGroupLocationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocationState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocationState> {
    private static final SdkField<Integer> ALLOCATED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedCapacity").getter(LocationState.getter(LocationState::allocatedCapacity)).setter(LocationState.setter(Builder::allocatedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedCapacity").build()}).build();
    private static final SdkField<Integer> ALWAYS_ON_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AlwaysOnCapacity").getter(LocationState.getter(LocationState::alwaysOnCapacity)).setter(LocationState.setter(Builder::alwaysOnCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlwaysOnCapacity").build()}).build();
    private static final SdkField<Integer> IDLE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IdleCapacity").getter(LocationState.getter(LocationState::idleCapacity)).setter(LocationState.setter(Builder::idleCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleCapacity").build()}).build();
    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationName").getter(LocationState.getter(LocationState::locationName)).setter(LocationState.setter(Builder::locationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationName").build()}).build();
    private static final SdkField<Integer> ON_DEMAND_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OnDemandCapacity").getter(LocationState.getter(LocationState::onDemandCapacity)).setter(LocationState.setter(Builder::onDemandCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandCapacity").build()}).build();
    private static final SdkField<Integer> REQUESTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RequestedCapacity").getter(LocationState.getter(LocationState::requestedCapacity)).setter(LocationState.setter(Builder::requestedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedCapacity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LocationState.getter(LocationState::statusAsString)).setter(LocationState.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_CAPACITY_FIELD, ALWAYS_ON_CAPACITY_FIELD, IDLE_CAPACITY_FIELD, LOCATION_NAME_FIELD, ON_DEMAND_CAPACITY_FIELD, REQUESTED_CAPACITY_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LocationState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer allocatedCapacity;
    private final Integer alwaysOnCapacity;
    private final Integer idleCapacity;
    private final String locationName;
    private final Integer onDemandCapacity;
    private final Integer requestedCapacity;
    private final String status;

    private LocationState(BuilderImpl builder) {
        this.allocatedCapacity = builder.allocatedCapacity;
        this.alwaysOnCapacity = builder.alwaysOnCapacity;
        this.idleCapacity = builder.idleCapacity;
        this.locationName = builder.locationName;
        this.onDemandCapacity = builder.onDemandCapacity;
        this.requestedCapacity = builder.requestedCapacity;
        this.status = builder.status;
    }

    public final Integer allocatedCapacity() {
        return this.allocatedCapacity;
    }

    public final Integer alwaysOnCapacity() {
        return this.alwaysOnCapacity;
    }

    public final Integer idleCapacity() {
        return this.idleCapacity;
    }

    public final String locationName() {
        return this.locationName;
    }

    public final Integer onDemandCapacity() {
        return this.onDemandCapacity;
    }

    public final Integer requestedCapacity() {
        return this.requestedCapacity;
    }

    public final StreamGroupLocationStatus status() {
        return StreamGroupLocationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.alwaysOnCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationState)) {
            return false;
        }
        LocationState other = (LocationState)obj;
        return Objects.equals(this.allocatedCapacity(), other.allocatedCapacity()) && Objects.equals(this.alwaysOnCapacity(), other.alwaysOnCapacity()) && Objects.equals(this.idleCapacity(), other.idleCapacity()) && Objects.equals(this.locationName(), other.locationName()) && Objects.equals(this.onDemandCapacity(), other.onDemandCapacity()) && Objects.equals(this.requestedCapacity(), other.requestedCapacity()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LocationState").add("AllocatedCapacity", (Object)this.allocatedCapacity()).add("AlwaysOnCapacity", (Object)this.alwaysOnCapacity()).add("IdleCapacity", (Object)this.idleCapacity()).add("LocationName", (Object)this.locationName()).add("OnDemandCapacity", (Object)this.onDemandCapacity()).add("RequestedCapacity", (Object)this.requestedCapacity()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocatedCapacity": {
                return Optional.ofNullable(clazz.cast(this.allocatedCapacity()));
            }
            case "AlwaysOnCapacity": {
                return Optional.ofNullable(clazz.cast(this.alwaysOnCapacity()));
            }
            case "IdleCapacity": {
                return Optional.ofNullable(clazz.cast(this.idleCapacity()));
            }
            case "LocationName": {
                return Optional.ofNullable(clazz.cast(this.locationName()));
            }
            case "OnDemandCapacity": {
                return Optional.ofNullable(clazz.cast(this.onDemandCapacity()));
            }
            case "RequestedCapacity": {
                return Optional.ofNullable(clazz.cast(this.requestedCapacity()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllocatedCapacity", ALLOCATED_CAPACITY_FIELD);
        map.put("AlwaysOnCapacity", ALWAYS_ON_CAPACITY_FIELD);
        map.put("IdleCapacity", IDLE_CAPACITY_FIELD);
        map.put("LocationName", LOCATION_NAME_FIELD);
        map.put("OnDemandCapacity", ON_DEMAND_CAPACITY_FIELD);
        map.put("RequestedCapacity", REQUESTED_CAPACITY_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocationState, T> g) {
        return obj -> g.apply((LocationState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer allocatedCapacity;
        private Integer alwaysOnCapacity;
        private Integer idleCapacity;
        private String locationName;
        private Integer onDemandCapacity;
        private Integer requestedCapacity;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationState model) {
            this.allocatedCapacity(model.allocatedCapacity);
            this.alwaysOnCapacity(model.alwaysOnCapacity);
            this.idleCapacity(model.idleCapacity);
            this.locationName(model.locationName);
            this.onDemandCapacity(model.onDemandCapacity);
            this.requestedCapacity(model.requestedCapacity);
            this.status(model.status);
        }

        public final Integer getAllocatedCapacity() {
            return this.allocatedCapacity;
        }

        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        @Override
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final Integer getAlwaysOnCapacity() {
            return this.alwaysOnCapacity;
        }

        public final void setAlwaysOnCapacity(Integer alwaysOnCapacity) {
            this.alwaysOnCapacity = alwaysOnCapacity;
        }

        @Override
        public final Builder alwaysOnCapacity(Integer alwaysOnCapacity) {
            this.alwaysOnCapacity = alwaysOnCapacity;
            return this;
        }

        public final Integer getIdleCapacity() {
            return this.idleCapacity;
        }

        public final void setIdleCapacity(Integer idleCapacity) {
            this.idleCapacity = idleCapacity;
        }

        @Override
        public final Builder idleCapacity(Integer idleCapacity) {
            this.idleCapacity = idleCapacity;
            return this;
        }

        public final String getLocationName() {
            return this.locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final Integer getOnDemandCapacity() {
            return this.onDemandCapacity;
        }

        public final void setOnDemandCapacity(Integer onDemandCapacity) {
            this.onDemandCapacity = onDemandCapacity;
        }

        @Override
        public final Builder onDemandCapacity(Integer onDemandCapacity) {
            this.onDemandCapacity = onDemandCapacity;
            return this;
        }

        public final Integer getRequestedCapacity() {
            return this.requestedCapacity;
        }

        public final void setRequestedCapacity(Integer requestedCapacity) {
            this.requestedCapacity = requestedCapacity;
        }

        @Override
        public final Builder requestedCapacity(Integer requestedCapacity) {
            this.requestedCapacity = requestedCapacity;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamGroupLocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public LocationState build() {
            return new LocationState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocationState> {
        public Builder allocatedCapacity(Integer var1);

        public Builder alwaysOnCapacity(Integer var1);

        public Builder idleCapacity(Integer var1);

        public Builder locationName(String var1);

        public Builder onDemandCapacity(Integer var1);

        public Builder requestedCapacity(Integer var1);

        public Builder status(String var1);

        public Builder status(StreamGroupLocationStatus var1);
    }
}

