/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.LocationConfiguration;
import software.amazon.awssdk.services.gameliftstreams.model.LocationConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStreamGroupRequest
extends GameLiftStreamsRequest
implements ToCopyableBuilder<Builder, UpdateStreamGroupRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateStreamGroupRequest.getter(UpdateStreamGroupRequest::description)).setter(UpdateStreamGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateStreamGroupRequest.getter(UpdateStreamGroupRequest::identifier)).setter(UpdateStreamGroupRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<List<LocationConfiguration>> LOCATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocationConfigurations").getter(UpdateStreamGroupRequest.getter(UpdateStreamGroupRequest::locationConfigurations)).setter(UpdateStreamGroupRequest.setter(Builder::locationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, IDENTIFIER_FIELD, LOCATION_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateStreamGroupRequest.memberNameToFieldInitializer();
    private final String description;
    private final String identifier;
    private final List<LocationConfiguration> locationConfigurations;

    private UpdateStreamGroupRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.identifier = builder.identifier;
        this.locationConfigurations = builder.locationConfigurations;
    }

    public final String description() {
        return this.description;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final boolean hasLocationConfigurations() {
        return this.locationConfigurations != null && !(this.locationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LocationConfiguration> locationConfigurations() {
        return this.locationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationConfigurations() ? this.locationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamGroupRequest)) {
            return false;
        }
        UpdateStreamGroupRequest other = (UpdateStreamGroupRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.identifier(), other.identifier()) && this.hasLocationConfigurations() == other.hasLocationConfigurations() && Objects.equals(this.locationConfigurations(), other.locationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStreamGroupRequest").add("Description", (Object)this.description()).add("Identifier", (Object)this.identifier()).add("LocationConfigurations", this.hasLocationConfigurations() ? this.locationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "LocationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.locationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("LocationConfigurations", LOCATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamGroupRequest, T> g) {
        return obj -> g.apply((UpdateStreamGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsRequest.BuilderImpl
    implements Builder {
        private String description;
        private String identifier;
        private List<LocationConfiguration> locationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamGroupRequest model) {
            super(model);
            this.description(model.description);
            this.identifier(model.identifier);
            this.locationConfigurations(model.locationConfigurations);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<LocationConfiguration.Builder> getLocationConfigurations() {
            List<LocationConfiguration.Builder> result = LocationConfigurationsCopier.copyToBuilder(this.locationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationConfigurations(Collection<LocationConfiguration.BuilderImpl> locationConfigurations) {
            this.locationConfigurations = LocationConfigurationsCopier.copyFromBuilder(locationConfigurations);
        }

        @Override
        public final Builder locationConfigurations(Collection<LocationConfiguration> locationConfigurations) {
            this.locationConfigurations = LocationConfigurationsCopier.copy(locationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationConfigurations(LocationConfiguration ... locationConfigurations) {
            this.locationConfigurations(Arrays.asList(locationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationConfigurations(Consumer<LocationConfiguration.Builder> ... locationConfigurations) {
            this.locationConfigurations(Stream.of(locationConfigurations).map(c -> (LocationConfiguration)((LocationConfiguration.Builder)LocationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamGroupRequest build() {
            return new UpdateStreamGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStreamGroupRequest> {
        public Builder description(String var1);

        public Builder identifier(String var1);

        public Builder locationConfigurations(Collection<LocationConfiguration> var1);

        public Builder locationConfigurations(LocationConfiguration ... var1);

        public Builder locationConfigurations(Consumer<LocationConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

