/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gameliftstreams.model.ArnListCopier;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateApplicationsResponse
extends GameLiftStreamsResponse
implements ToCopyableBuilder<Builder, DisassociateApplicationsResponse> {
    private static final SdkField<List<String>> APPLICATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationArns").getter(DisassociateApplicationsResponse.getter(DisassociateApplicationsResponse::applicationArns)).setter(DisassociateApplicationsResponse.setter(Builder::applicationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DisassociateApplicationsResponse.getter(DisassociateApplicationsResponse::arn)).setter(DisassociateApplicationsResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARNS_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateApplicationsResponse.memberNameToFieldInitializer();
    private final List<String> applicationArns;
    private final String arn;

    private DisassociateApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationArns = builder.applicationArns;
        this.arn = builder.arn;
    }

    public final boolean hasApplicationArns() {
        return this.applicationArns != null && !(this.applicationArns instanceof SdkAutoConstructList);
    }

    public final List<String> applicationArns() {
        return this.applicationArns;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationArns() ? this.applicationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateApplicationsResponse)) {
            return false;
        }
        DisassociateApplicationsResponse other = (DisassociateApplicationsResponse)((Object)obj);
        return this.hasApplicationArns() == other.hasApplicationArns() && Objects.equals(this.applicationArns(), other.applicationArns()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateApplicationsResponse").add("ApplicationArns", this.hasApplicationArns() ? this.applicationArns() : null).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArns": {
                return Optional.ofNullable(clazz.cast(this.applicationArns()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationArns", APPLICATION_ARNS_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateApplicationsResponse, T> g) {
        return obj -> g.apply((DisassociateApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsResponse.BuilderImpl
    implements Builder {
        private List<String> applicationArns = DefaultSdkAutoConstructList.getInstance();
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateApplicationsResponse model) {
            super(model);
            this.applicationArns(model.applicationArns);
            this.arn(model.arn);
        }

        public final Collection<String> getApplicationArns() {
            if (this.applicationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationArns;
        }

        public final void setApplicationArns(Collection<String> applicationArns) {
            this.applicationArns = ArnListCopier.copy(applicationArns);
        }

        @Override
        public final Builder applicationArns(Collection<String> applicationArns) {
            this.applicationArns = ArnListCopier.copy(applicationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationArns(String ... applicationArns) {
            this.applicationArns(Arrays.asList(applicationArns));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public DisassociateApplicationsResponse build() {
            return new DisassociateApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftStreamsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateApplicationsResponse> {
        public Builder applicationArns(Collection<String> var1);

        public Builder applicationArns(String ... var1);

        public Builder arn(String var1);
    }
}

