/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamSessionConnectionRequest
extends GameLiftStreamsRequest
implements ToCopyableBuilder<Builder, CreateStreamSessionConnectionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateStreamSessionConnectionRequest.getter(CreateStreamSessionConnectionRequest::clientToken)).setter(CreateStreamSessionConnectionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(CreateStreamSessionConnectionRequest.getter(CreateStreamSessionConnectionRequest::identifier)).setter(CreateStreamSessionConnectionRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> SIGNAL_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignalRequest").getter(CreateStreamSessionConnectionRequest.getter(CreateStreamSessionConnectionRequest::signalRequest)).setter(CreateStreamSessionConnectionRequest.setter(Builder::signalRequest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalRequest").build()}).build();
    private static final SdkField<String> STREAM_SESSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamSessionIdentifier").getter(CreateStreamSessionConnectionRequest.getter(CreateStreamSessionConnectionRequest::streamSessionIdentifier)).setter(CreateStreamSessionConnectionRequest.setter(Builder::streamSessionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("StreamSessionIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, IDENTIFIER_FIELD, SIGNAL_REQUEST_FIELD, STREAM_SESSION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateStreamSessionConnectionRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String identifier;
    private final String signalRequest;
    private final String streamSessionIdentifier;

    private CreateStreamSessionConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.identifier = builder.identifier;
        this.signalRequest = builder.signalRequest;
        this.streamSessionIdentifier = builder.streamSessionIdentifier;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String signalRequest() {
        return this.signalRequest;
    }

    public final String streamSessionIdentifier() {
        return this.streamSessionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSessionIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamSessionConnectionRequest)) {
            return false;
        }
        CreateStreamSessionConnectionRequest other = (CreateStreamSessionConnectionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.signalRequest(), other.signalRequest()) && Objects.equals(this.streamSessionIdentifier(), other.streamSessionIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStreamSessionConnectionRequest").add("ClientToken", (Object)this.clientToken()).add("Identifier", (Object)this.identifier()).add("SignalRequest", (Object)(this.signalRequest() == null ? null : "*** Sensitive Data Redacted ***")).add("StreamSessionIdentifier", (Object)this.streamSessionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "SignalRequest": {
                return Optional.ofNullable(clazz.cast(this.signalRequest()));
            }
            case "StreamSessionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.streamSessionIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("SignalRequest", SIGNAL_REQUEST_FIELD);
        map.put("StreamSessionIdentifier", STREAM_SESSION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamSessionConnectionRequest, T> g) {
        return obj -> g.apply((CreateStreamSessionConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String identifier;
        private String signalRequest;
        private String streamSessionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamSessionConnectionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.identifier(model.identifier);
            this.signalRequest(model.signalRequest);
            this.streamSessionIdentifier(model.streamSessionIdentifier);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getSignalRequest() {
            return this.signalRequest;
        }

        public final void setSignalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
        }

        @Override
        public final Builder signalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
            return this;
        }

        public final String getStreamSessionIdentifier() {
            return this.streamSessionIdentifier;
        }

        public final void setStreamSessionIdentifier(String streamSessionIdentifier) {
            this.streamSessionIdentifier = streamSessionIdentifier;
        }

        @Override
        public final Builder streamSessionIdentifier(String streamSessionIdentifier) {
            this.streamSessionIdentifier = streamSessionIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamSessionConnectionRequest build() {
            return new CreateStreamSessionConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStreamSessionConnectionRequest> {
        public Builder clientToken(String var1);

        public Builder identifier(String var1);

        public Builder signalRequest(String var1);

        public Builder streamSessionIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

