/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gameliftstreams.model.FilePathsCopier;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationRequest
extends GameLiftStreamsRequest
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_LOG_OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationLogOutputUri").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::applicationLogOutputUri)).setter(UpdateApplicationRequest.setter(Builder::applicationLogOutputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogOutputUri").build()}).build();
    private static final SdkField<List<String>> APPLICATION_LOG_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationLogPaths").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::applicationLogPaths)).setter(UpdateApplicationRequest.setter(Builder::applicationLogPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::description)).setter(UpdateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::identifier)).setter(UpdateApplicationRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_LOG_OUTPUT_URI_FIELD, APPLICATION_LOG_PATHS_FIELD, DESCRIPTION_FIELD, IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateApplicationRequest.memberNameToFieldInitializer();
    private final String applicationLogOutputUri;
    private final List<String> applicationLogPaths;
    private final String description;
    private final String identifier;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationLogOutputUri = builder.applicationLogOutputUri;
        this.applicationLogPaths = builder.applicationLogPaths;
        this.description = builder.description;
        this.identifier = builder.identifier;
    }

    public final String applicationLogOutputUri() {
        return this.applicationLogOutputUri;
    }

    public final boolean hasApplicationLogPaths() {
        return this.applicationLogPaths != null && !(this.applicationLogPaths instanceof SdkAutoConstructList);
    }

    public final List<String> applicationLogPaths() {
        return this.applicationLogPaths;
    }

    public final String description() {
        return this.description;
    }

    public final String identifier() {
        return this.identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationLogOutputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationLogPaths() ? this.applicationLogPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationLogOutputUri(), other.applicationLogOutputUri()) && this.hasApplicationLogPaths() == other.hasApplicationLogPaths() && Objects.equals(this.applicationLogPaths(), other.applicationLogPaths()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.identifier(), other.identifier());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationRequest").add("ApplicationLogOutputUri", (Object)this.applicationLogOutputUri()).add("ApplicationLogPaths", this.hasApplicationLogPaths() ? this.applicationLogPaths() : null).add("Description", (Object)this.description()).add("Identifier", (Object)this.identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationLogOutputUri": {
                return Optional.ofNullable(clazz.cast(this.applicationLogOutputUri()));
            }
            case "ApplicationLogPaths": {
                return Optional.ofNullable(clazz.cast(this.applicationLogPaths()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationLogOutputUri", APPLICATION_LOG_OUTPUT_URI_FIELD);
        map.put("ApplicationLogPaths", APPLICATION_LOG_PATHS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsRequest.BuilderImpl
    implements Builder {
        private String applicationLogOutputUri;
        private List<String> applicationLogPaths = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            this.applicationLogOutputUri(model.applicationLogOutputUri);
            this.applicationLogPaths(model.applicationLogPaths);
            this.description(model.description);
            this.identifier(model.identifier);
        }

        public final String getApplicationLogOutputUri() {
            return this.applicationLogOutputUri;
        }

        public final void setApplicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
        }

        @Override
        public final Builder applicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
            return this;
        }

        public final Collection<String> getApplicationLogPaths() {
            if (this.applicationLogPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationLogPaths;
        }

        public final void setApplicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
        }

        @Override
        public final Builder applicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationLogPaths(String ... applicationLogPaths) {
            this.applicationLogPaths(Arrays.asList(applicationLogPaths));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder applicationLogOutputUri(String var1);

        public Builder applicationLogPaths(Collection<String> var1);

        public Builder applicationLogPaths(String ... var1);

        public Builder description(String var1);

        public Builder identifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

