/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gameliftstreams.model.ApplicationStatus;
import software.amazon.awssdk.services.gameliftstreams.model.ApplicationStatusReason;
import software.amazon.awssdk.services.gameliftstreams.model.ArnListCopier;
import software.amazon.awssdk.services.gameliftstreams.model.FilePathsCopier;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.ReplicationStatus;
import software.amazon.awssdk.services.gameliftstreams.model.ReplicationStatusesCopier;
import software.amazon.awssdk.services.gameliftstreams.model.RuntimeEnvironment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationResponse
extends GameLiftStreamsResponse
implements ToCopyableBuilder<Builder, CreateApplicationResponse> {
    private static final SdkField<String> APPLICATION_LOG_OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationLogOutputUri").getter(CreateApplicationResponse.getter(CreateApplicationResponse::applicationLogOutputUri)).setter(CreateApplicationResponse.setter(Builder::applicationLogOutputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogOutputUri").build()}).build();
    private static final SdkField<List<String>> APPLICATION_LOG_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationLogPaths").getter(CreateApplicationResponse.getter(CreateApplicationResponse::applicationLogPaths)).setter(CreateApplicationResponse.setter(Builder::applicationLogPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationSourceUri").getter(CreateApplicationResponse.getter(CreateApplicationResponse::applicationSourceUri)).setter(CreateApplicationResponse.setter(Builder::applicationSourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSourceUri").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateApplicationResponse.getter(CreateApplicationResponse::arn)).setter(CreateApplicationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_STREAM_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedStreamGroups").getter(CreateApplicationResponse.getter(CreateApplicationResponse::associatedStreamGroups)).setter(CreateApplicationResponse.setter(Builder::associatedStreamGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedStreamGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CreateApplicationResponse.getter(CreateApplicationResponse::createdAt)).setter(CreateApplicationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateApplicationResponse.getter(CreateApplicationResponse::description)).setter(CreateApplicationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> EXECUTABLE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutablePath").getter(CreateApplicationResponse.getter(CreateApplicationResponse::executablePath)).setter(CreateApplicationResponse.setter(Builder::executablePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutablePath").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateApplicationResponse.getter(CreateApplicationResponse::id)).setter(CreateApplicationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(CreateApplicationResponse.getter(CreateApplicationResponse::lastUpdatedAt)).setter(CreateApplicationResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<List<ReplicationStatus>> REPLICATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationStatuses").getter(CreateApplicationResponse.getter(CreateApplicationResponse::replicationStatuses)).setter(CreateApplicationResponse.setter(Builder::replicationStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RuntimeEnvironment> RUNTIME_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeEnvironment").getter(CreateApplicationResponse.getter(CreateApplicationResponse::runtimeEnvironment)).setter(CreateApplicationResponse.setter(Builder::runtimeEnvironment)).constructor(RuntimeEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateApplicationResponse.getter(CreateApplicationResponse::statusAsString)).setter(CreateApplicationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(CreateApplicationResponse.getter(CreateApplicationResponse::statusReasonAsString)).setter(CreateApplicationResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_LOG_OUTPUT_URI_FIELD, APPLICATION_LOG_PATHS_FIELD, APPLICATION_SOURCE_URI_FIELD, ARN_FIELD, ASSOCIATED_STREAM_GROUPS_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, EXECUTABLE_PATH_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, REPLICATION_STATUSES_FIELD, RUNTIME_ENVIRONMENT_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApplicationResponse.memberNameToFieldInitializer();
    private final String applicationLogOutputUri;
    private final List<String> applicationLogPaths;
    private final String applicationSourceUri;
    private final String arn;
    private final List<String> associatedStreamGroups;
    private final Instant createdAt;
    private final String description;
    private final String executablePath;
    private final String id;
    private final Instant lastUpdatedAt;
    private final List<ReplicationStatus> replicationStatuses;
    private final RuntimeEnvironment runtimeEnvironment;
    private final String status;
    private final String statusReason;

    private CreateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationLogOutputUri = builder.applicationLogOutputUri;
        this.applicationLogPaths = builder.applicationLogPaths;
        this.applicationSourceUri = builder.applicationSourceUri;
        this.arn = builder.arn;
        this.associatedStreamGroups = builder.associatedStreamGroups;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.executablePath = builder.executablePath;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.replicationStatuses = builder.replicationStatuses;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final String applicationLogOutputUri() {
        return this.applicationLogOutputUri;
    }

    public final boolean hasApplicationLogPaths() {
        return this.applicationLogPaths != null && !(this.applicationLogPaths instanceof SdkAutoConstructList);
    }

    public final List<String> applicationLogPaths() {
        return this.applicationLogPaths;
    }

    public final String applicationSourceUri() {
        return this.applicationSourceUri;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAssociatedStreamGroups() {
        return this.associatedStreamGroups != null && !(this.associatedStreamGroups instanceof SdkAutoConstructList);
    }

    public final List<String> associatedStreamGroups() {
        return this.associatedStreamGroups;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String executablePath() {
        return this.executablePath;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasReplicationStatuses() {
        return this.replicationStatuses != null && !(this.replicationStatuses instanceof SdkAutoConstructList);
    }

    public final List<ReplicationStatus> replicationStatuses() {
        return this.replicationStatuses;
    }

    public final RuntimeEnvironment runtimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ApplicationStatusReason statusReason() {
        return ApplicationStatusReason.fromValue(this.statusReason);
    }

    public final String statusReasonAsString() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationLogOutputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationLogPaths() ? this.applicationLogPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedStreamGroups() ? this.associatedStreamGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.executablePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationStatuses() ? this.replicationStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse)((Object)obj);
        return Objects.equals(this.applicationLogOutputUri(), other.applicationLogOutputUri()) && this.hasApplicationLogPaths() == other.hasApplicationLogPaths() && Objects.equals(this.applicationLogPaths(), other.applicationLogPaths()) && Objects.equals(this.applicationSourceUri(), other.applicationSourceUri()) && Objects.equals(this.arn(), other.arn()) && this.hasAssociatedStreamGroups() == other.hasAssociatedStreamGroups() && Objects.equals(this.associatedStreamGroups(), other.associatedStreamGroups()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.executablePath(), other.executablePath()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasReplicationStatuses() == other.hasReplicationStatuses() && Objects.equals(this.replicationStatuses(), other.replicationStatuses()) && Objects.equals(this.runtimeEnvironment(), other.runtimeEnvironment()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReasonAsString(), other.statusReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationResponse").add("ApplicationLogOutputUri", (Object)this.applicationLogOutputUri()).add("ApplicationLogPaths", this.hasApplicationLogPaths() ? this.applicationLogPaths() : null).add("ApplicationSourceUri", (Object)this.applicationSourceUri()).add("Arn", (Object)this.arn()).add("AssociatedStreamGroups", this.hasAssociatedStreamGroups() ? this.associatedStreamGroups() : null).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("ExecutablePath", (Object)this.executablePath()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ReplicationStatuses", this.hasReplicationStatuses() ? this.replicationStatuses() : null).add("RuntimeEnvironment", (Object)this.runtimeEnvironment()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationLogOutputUri": {
                return Optional.ofNullable(clazz.cast(this.applicationLogOutputUri()));
            }
            case "ApplicationLogPaths": {
                return Optional.ofNullable(clazz.cast(this.applicationLogPaths()));
            }
            case "ApplicationSourceUri": {
                return Optional.ofNullable(clazz.cast(this.applicationSourceUri()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AssociatedStreamGroups": {
                return Optional.ofNullable(clazz.cast(this.associatedStreamGroups()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ExecutablePath": {
                return Optional.ofNullable(clazz.cast(this.executablePath()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "ReplicationStatuses": {
                return Optional.ofNullable(clazz.cast(this.replicationStatuses()));
            }
            case "RuntimeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironment()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationLogOutputUri", APPLICATION_LOG_OUTPUT_URI_FIELD);
        map.put("ApplicationLogPaths", APPLICATION_LOG_PATHS_FIELD);
        map.put("ApplicationSourceUri", APPLICATION_SOURCE_URI_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("AssociatedStreamGroups", ASSOCIATED_STREAM_GROUPS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ExecutablePath", EXECUTABLE_PATH_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("ReplicationStatuses", REPLICATION_STATUSES_FIELD);
        map.put("RuntimeEnvironment", RUNTIME_ENVIRONMENT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationResponse, T> g) {
        return obj -> g.apply((CreateApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsResponse.BuilderImpl
    implements Builder {
        private String applicationLogOutputUri;
        private List<String> applicationLogPaths = DefaultSdkAutoConstructList.getInstance();
        private String applicationSourceUri;
        private String arn;
        private List<String> associatedStreamGroups = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String description;
        private String executablePath;
        private String id;
        private Instant lastUpdatedAt;
        private List<ReplicationStatus> replicationStatuses = DefaultSdkAutoConstructList.getInstance();
        private RuntimeEnvironment runtimeEnvironment;
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            super(model);
            this.applicationLogOutputUri(model.applicationLogOutputUri);
            this.applicationLogPaths(model.applicationLogPaths);
            this.applicationSourceUri(model.applicationSourceUri);
            this.arn(model.arn);
            this.associatedStreamGroups(model.associatedStreamGroups);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.executablePath(model.executablePath);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.replicationStatuses(model.replicationStatuses);
            this.runtimeEnvironment(model.runtimeEnvironment);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getApplicationLogOutputUri() {
            return this.applicationLogOutputUri;
        }

        public final void setApplicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
        }

        @Override
        public final Builder applicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
            return this;
        }

        public final Collection<String> getApplicationLogPaths() {
            if (this.applicationLogPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationLogPaths;
        }

        public final void setApplicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
        }

        @Override
        public final Builder applicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationLogPaths(String ... applicationLogPaths) {
            this.applicationLogPaths(Arrays.asList(applicationLogPaths));
            return this;
        }

        public final String getApplicationSourceUri() {
            return this.applicationSourceUri;
        }

        public final void setApplicationSourceUri(String applicationSourceUri) {
            this.applicationSourceUri = applicationSourceUri;
        }

        @Override
        public final Builder applicationSourceUri(String applicationSourceUri) {
            this.applicationSourceUri = applicationSourceUri;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAssociatedStreamGroups() {
            if (this.associatedStreamGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedStreamGroups;
        }

        public final void setAssociatedStreamGroups(Collection<String> associatedStreamGroups) {
            this.associatedStreamGroups = ArnListCopier.copy(associatedStreamGroups);
        }

        @Override
        public final Builder associatedStreamGroups(Collection<String> associatedStreamGroups) {
            this.associatedStreamGroups = ArnListCopier.copy(associatedStreamGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedStreamGroups(String ... associatedStreamGroups) {
            this.associatedStreamGroups(Arrays.asList(associatedStreamGroups));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutablePath() {
            return this.executablePath;
        }

        public final void setExecutablePath(String executablePath) {
            this.executablePath = executablePath;
        }

        @Override
        public final Builder executablePath(String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final List<ReplicationStatus.Builder> getReplicationStatuses() {
            List<ReplicationStatus.Builder> result = ReplicationStatusesCopier.copyToBuilder(this.replicationStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationStatuses(Collection<ReplicationStatus.BuilderImpl> replicationStatuses) {
            this.replicationStatuses = ReplicationStatusesCopier.copyFromBuilder(replicationStatuses);
        }

        @Override
        public final Builder replicationStatuses(Collection<ReplicationStatus> replicationStatuses) {
            this.replicationStatuses = ReplicationStatusesCopier.copy(replicationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatuses(ReplicationStatus ... replicationStatuses) {
            this.replicationStatuses(Arrays.asList(replicationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatuses(Consumer<ReplicationStatus.Builder> ... replicationStatuses) {
            this.replicationStatuses(Stream.of(replicationStatuses).map(c -> (ReplicationStatus)((ReplicationStatus.Builder)ReplicationStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RuntimeEnvironment.Builder getRuntimeEnvironment() {
            return this.runtimeEnvironment != null ? this.runtimeEnvironment.toBuilder() : null;
        }

        public final void setRuntimeEnvironment(RuntimeEnvironment.BuilderImpl runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment != null ? runtimeEnvironment.build() : null;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ApplicationStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftStreamsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationResponse> {
        public Builder applicationLogOutputUri(String var1);

        public Builder applicationLogPaths(Collection<String> var1);

        public Builder applicationLogPaths(String ... var1);

        public Builder applicationSourceUri(String var1);

        public Builder arn(String var1);

        public Builder associatedStreamGroups(Collection<String> var1);

        public Builder associatedStreamGroups(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder executablePath(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder replicationStatuses(Collection<ReplicationStatus> var1);

        public Builder replicationStatuses(ReplicationStatus ... var1);

        public Builder replicationStatuses(Consumer<ReplicationStatus.Builder> ... var1);

        public Builder runtimeEnvironment(RuntimeEnvironment var1);

        default public Builder runtimeEnvironment(Consumer<RuntimeEnvironment.Builder> runtimeEnvironment) {
            return this.runtimeEnvironment((RuntimeEnvironment)((RuntimeEnvironment.Builder)RuntimeEnvironment.builder().applyMutation(runtimeEnvironment)).build());
        }

        public Builder status(String var1);

        public Builder status(ApplicationStatus var1);

        public Builder statusReason(String var1);

        public Builder statusReason(ApplicationStatusReason var1);
    }
}

