/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamClass {
    GEN4_N_HIGH("gen4n_high"),
    GEN4_N_ULTRA("gen4n_ultra"),
    GEN4_N_WIN2022("gen4n_win2022"),
    GEN5_N_HIGH("gen5n_high"),
    GEN5_N_ULTRA("gen5n_ultra"),
    GEN5_N_WIN2022("gen5n_win2022"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamClass> VALUE_MAP;
    private final String value;

    private StreamClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamClass> knownValues() {
        EnumSet<StreamClass> knownValues = EnumSet.allOf(StreamClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamClass.class, StreamClass::toString);
    }
}

