/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateScriptRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, UpdateScriptRequest> {
    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateScriptRequest.getter(UpdateScriptRequest::scriptId)).setter(UpdateScriptRequest.setter(Builder::scriptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateScriptRequest.getter(UpdateScriptRequest::name)).setter(UpdateScriptRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateScriptRequest.getter(UpdateScriptRequest::version)).setter(UpdateScriptRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<S3Location> STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateScriptRequest.getter(UpdateScriptRequest::storageLocation)).setter(UpdateScriptRequest.setter(Builder::storageLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()}).build();
    private static final SdkField<SdkBytes> ZIP_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(UpdateScriptRequest.getter(UpdateScriptRequest::zipFile)).setter(UpdateScriptRequest.setter(Builder::zipFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipFile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_ID_FIELD, NAME_FIELD, VERSION_FIELD, STORAGE_LOCATION_FIELD, ZIP_FILE_FIELD));
    private final String scriptId;
    private final String name;
    private final String version;
    private final S3Location storageLocation;
    private final SdkBytes zipFile;

    private UpdateScriptRequest(BuilderImpl builder) {
        super(builder);
        this.scriptId = builder.scriptId;
        this.name = builder.name;
        this.version = builder.version;
        this.storageLocation = builder.storageLocation;
        this.zipFile = builder.zipFile;
    }

    public String scriptId() {
        return this.scriptId;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public S3Location storageLocation() {
        return this.storageLocation;
    }

    public SdkBytes zipFile() {
        return this.zipFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.zipFile());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScriptRequest)) {
            return false;
        }
        UpdateScriptRequest other = (UpdateScriptRequest)((Object)obj);
        return Objects.equals(this.scriptId(), other.scriptId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.storageLocation(), other.storageLocation()) && Objects.equals(this.zipFile(), other.zipFile());
    }

    public String toString() {
        return ToString.builder((String)"UpdateScriptRequest").add("ScriptId", (Object)this.scriptId()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("StorageLocation", (Object)this.storageLocation()).add("ZipFile", (Object)this.zipFile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScriptId": {
                return Optional.ofNullable(clazz.cast(this.scriptId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "StorageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
            case "ZipFile": {
                return Optional.ofNullable(clazz.cast(this.zipFile()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateScriptRequest, T> g) {
        return obj -> g.apply((UpdateScriptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String scriptId;
        private String name;
        private String version;
        private S3Location storageLocation;
        private SdkBytes zipFile;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScriptRequest model) {
            super(model);
            this.scriptId(model.scriptId);
            this.name(model.name);
            this.version(model.version);
            this.storageLocation(model.storageLocation);
            this.zipFile(model.zipFile);
        }

        public final String getScriptId() {
            return this.scriptId;
        }

        @Override
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final S3Location.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        @Override
        public final Builder storageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final void setStorageLocation(S3Location.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        public final ByteBuffer getZipFile() {
            return this.zipFile == null ? null : this.zipFile.asByteBuffer();
        }

        @Override
        public final Builder zipFile(SdkBytes zipFile) {
            this.zipFile = StandardMemberCopier.copy((SdkBytes)zipFile);
            return this;
        }

        public final void setZipFile(ByteBuffer zipFile) {
            this.zipFile(zipFile == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)zipFile));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScriptRequest build() {
            return new UpdateScriptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateScriptRequest> {
        public Builder scriptId(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder storageLocation(S3Location var1);

        default public Builder storageLocation(Consumer<S3Location.Builder> storageLocation) {
            return this.storageLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(storageLocation)).build());
        }

        public Builder zipFile(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

