/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.IpProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpPermission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpPermission> {
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(IpPermission.getter(IpPermission::fromPort)).setter(IpPermission.setter(Builder::fromPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").build()}).build();
    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(IpPermission.getter(IpPermission::toPort)).setter(IpPermission.setter(Builder::toPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").build()}).build();
    private static final SdkField<String> IP_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IpPermission.getter(IpPermission::ipRange)).setter(IpPermission.setter(Builder::ipRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRange").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IpPermission.getter(IpPermission::protocolAsString)).setter(IpPermission.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PORT_FIELD, TO_PORT_FIELD, IP_RANGE_FIELD, PROTOCOL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer fromPort;
    private final Integer toPort;
    private final String ipRange;
    private final String protocol;

    private IpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.ipRange = builder.ipRange;
        this.protocol = builder.protocol;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public String ipRange() {
        return this.ipRange;
    }

    public IpProtocol protocol() {
        return IpProtocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission)obj;
        return Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.toPort(), other.toPort()) && Objects.equals(this.ipRange(), other.ipRange()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public String toString() {
        return ToString.builder((String)"IpPermission").add("FromPort", (Object)this.fromPort()).add("ToPort", (Object)this.toPort()).add("IpRange", (Object)this.ipRange()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "ToPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
            case "IpRange": {
                return Optional.ofNullable(clazz.cast(this.ipRange()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpPermission, T> g) {
        return obj -> g.apply((IpPermission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private Integer toPort;
        private String ipRange;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(IpPermission model) {
            this.fromPort(model.fromPort);
            this.toPort(model.toPort);
            this.ipRange(model.ipRange);
            this.protocol(model.protocol);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getIpRange() {
            return this.ipRange;
        }

        @Override
        public final Builder ipRange(String ipRange) {
            this.ipRange = ipRange;
            return this;
        }

        public final void setIpRange(String ipRange) {
            this.ipRange = ipRange;
        }

        public final String getProtocolAsString() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(IpProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public IpPermission build() {
            return new IpPermission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpPermission> {
        public Builder fromPort(Integer var1);

        public Builder toPort(Integer var1);

        public Builder ipRange(String var1);

        public Builder protocol(String var1);

        public Builder protocol(IpProtocol var1);
    }
}

