/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContainerGroupDefinitionRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateContainerGroupDefinitionRequest.Builder, UpdateContainerGroupDefinitionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateContainerGroupDefinitionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<GameServerContainerDefinitionInput> GAME_SERVER_CONTAINER_DEFINITION_FIELD = SdkField
            .<GameServerContainerDefinitionInput> builder(MarshallingType.SDK_POJO)
            .memberName("GameServerContainerDefinition")
            .getter(getter(UpdateContainerGroupDefinitionRequest::gameServerContainerDefinition))
            .setter(setter(Builder::gameServerContainerDefinition))
            .constructor(GameServerContainerDefinitionInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerContainerDefinition")
                    .build()).build();

    private static final SdkField<List<SupportContainerDefinitionInput>> SUPPORT_CONTAINER_DEFINITIONS_FIELD = SdkField
            .<List<SupportContainerDefinitionInput>> builder(MarshallingType.LIST)
            .memberName("SupportContainerDefinitions")
            .getter(getter(UpdateContainerGroupDefinitionRequest::supportContainerDefinitions))
            .setter(setter(Builder::supportContainerDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportContainerDefinitions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupportContainerDefinitionInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportContainerDefinitionInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_MEMORY_LIMIT_MEBIBYTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("TotalMemoryLimitMebibytes")
            .getter(getter(UpdateContainerGroupDefinitionRequest::totalMemoryLimitMebibytes))
            .setter(setter(Builder::totalMemoryLimitMebibytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalMemoryLimitMebibytes").build())
            .build();

    private static final SdkField<Double> TOTAL_VCPU_LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalVcpuLimit").getter(getter(UpdateContainerGroupDefinitionRequest::totalVcpuLimit))
            .setter(setter(Builder::totalVcpuLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalVcpuLimit").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(UpdateContainerGroupDefinitionRequest::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<Integer> SOURCE_VERSION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SourceVersionNumber").getter(getter(UpdateContainerGroupDefinitionRequest::sourceVersionNumber))
            .setter(setter(Builder::sourceVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVersionNumber").build())
            .build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystem").getter(getter(UpdateContainerGroupDefinitionRequest::operatingSystemAsString))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            GAME_SERVER_CONTAINER_DEFINITION_FIELD, SUPPORT_CONTAINER_DEFINITIONS_FIELD, TOTAL_MEMORY_LIMIT_MEBIBYTES_FIELD,
            TOTAL_VCPU_LIMIT_FIELD, VERSION_DESCRIPTION_FIELD, SOURCE_VERSION_NUMBER_FIELD, OPERATING_SYSTEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final GameServerContainerDefinitionInput gameServerContainerDefinition;

    private final List<SupportContainerDefinitionInput> supportContainerDefinitions;

    private final Integer totalMemoryLimitMebibytes;

    private final Double totalVcpuLimit;

    private final String versionDescription;

    private final Integer sourceVersionNumber;

    private final String operatingSystem;

    private UpdateContainerGroupDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.gameServerContainerDefinition = builder.gameServerContainerDefinition;
        this.supportContainerDefinitions = builder.supportContainerDefinitions;
        this.totalMemoryLimitMebibytes = builder.totalMemoryLimitMebibytes;
        this.totalVcpuLimit = builder.totalVcpuLimit;
        this.versionDescription = builder.versionDescription;
        this.sourceVersionNumber = builder.sourceVersionNumber;
        this.operatingSystem = builder.operatingSystem;
    }

    /**
     * <p>
     * A descriptive identifier for the container group definition. The name value must be unique in an Amazon Web
     * Services Region.
     * </p>
     * 
     * @return A descriptive identifier for the container group definition. The name value must be unique in an Amazon
     *         Web Services Region.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An updated definition for the game server container in this group. Define a game server container only when the
     * container group type is <code>GAME_SERVER</code>. You can pass in your container definitions as a JSON file.
     * </p>
     * 
     * @return An updated definition for the game server container in this group. Define a game server container only
     *         when the container group type is <code>GAME_SERVER</code>. You can pass in your container definitions as
     *         a JSON file.
     */
    public final GameServerContainerDefinitionInput gameServerContainerDefinition() {
        return gameServerContainerDefinition;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportContainerDefinitions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportContainerDefinitions() {
        return supportContainerDefinitions != null && !(supportContainerDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more definitions for support containers in this group. You can define a support container in any type of
     * container group. You can pass in your container definitions as a JSON file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportContainerDefinitions} method.
     * </p>
     * 
     * @return One or more definitions for support containers in this group. You can define a support container in any
     *         type of container group. You can pass in your container definitions as a JSON file.
     */
    public final List<SupportContainerDefinitionInput> supportContainerDefinitions() {
        return supportContainerDefinitions;
    }

    /**
     * <p>
     * The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group share this
     * memory. If you specify memory limits for an individual container, the total value must be greater than any
     * individual container's memory limit.
     * </p>
     * 
     * @return The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group
     *         share this memory. If you specify memory limits for an individual container, the total value must be
     *         greater than any individual container's memory limit.
     */
    public final Integer totalMemoryLimitMebibytes() {
        return totalMemoryLimitMebibytes;
    }

    /**
     * <p>
     * The maximum amount of vCPU units to allocate to the container group (1 vCPU is equal to 1024 CPU units). All
     * containers in the group share this memory. If you specify vCPU limits for individual containers, the total value
     * must be equal to or greater than the sum of the CPU limits for all containers in the group.
     * </p>
     * 
     * @return The maximum amount of vCPU units to allocate to the container group (1 vCPU is equal to 1024 CPU units).
     *         All containers in the group share this memory. If you specify vCPU limits for individual containers, the
     *         total value must be equal to or greater than the sum of the CPU limits for all containers in the group.
     */
    public final Double totalVcpuLimit() {
        return totalVcpuLimit;
    }

    /**
     * <p>
     * A description for this update to the container group definition.
     * </p>
     * 
     * @return A description for this update to the container group definition.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * The container group definition version to update. The new version starts with values from the source version, and
     * then updates values included in this request.
     * </p>
     * 
     * @return The container group definition version to update. The new version starts with values from the source
     *         version, and then updates values included in this request.
     */
    public final Integer sourceVersionNumber() {
        return sourceVersionNumber;
    }

    /**
     * <p>
     * The platform that all containers in the group use. Containers in a group must run on the same operating system.
     * </p>
     * <note>
     * <p>
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a
     * href="http://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a>. For game servers that are hosted on
     * AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK
     * 5.x, and then deploy to AL2023 instances. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html"> Migrate to
     * server SDK version 5.</a>
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link ContainerOperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return The platform that all containers in the group use. Containers in a group must run on the same operating
     *         system.</p> <note>
     *         <p>
     *         Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a
     *         href="http://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a>. For game servers that are
     *         hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server
     *         build to server SDK 5.x, and then deploy to AL2023 instances. See <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">
     *         Migrate to server SDK version 5.</a>
     *         </p>
     * @see ContainerOperatingSystem
     */
    public final ContainerOperatingSystem operatingSystem() {
        return ContainerOperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * The platform that all containers in the group use. Containers in a group must run on the same operating system.
     * </p>
     * <note>
     * <p>
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a
     * href="http://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a>. For game servers that are hosted on
     * AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK
     * 5.x, and then deploy to AL2023 instances. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html"> Migrate to
     * server SDK version 5.</a>
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link ContainerOperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return The platform that all containers in the group use. Containers in a group must run on the same operating
     *         system.</p> <note>
     *         <p>
     *         Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a
     *         href="http://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a>. For game servers that are
     *         hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server
     *         build to server SDK 5.x, and then deploy to AL2023 instances. See <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">
     *         Migrate to server SDK version 5.</a>
     *         </p>
     * @see ContainerOperatingSystem
     */
    public final String operatingSystemAsString() {
        return operatingSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerContainerDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportContainerDefinitions() ? supportContainerDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalMemoryLimitMebibytes());
        hashCode = 31 * hashCode + Objects.hashCode(totalVcpuLimit());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContainerGroupDefinitionRequest)) {
            return false;
        }
        UpdateContainerGroupDefinitionRequest other = (UpdateContainerGroupDefinitionRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(gameServerContainerDefinition(), other.gameServerContainerDefinition())
                && hasSupportContainerDefinitions() == other.hasSupportContainerDefinitions()
                && Objects.equals(supportContainerDefinitions(), other.supportContainerDefinitions())
                && Objects.equals(totalMemoryLimitMebibytes(), other.totalMemoryLimitMebibytes())
                && Objects.equals(totalVcpuLimit(), other.totalVcpuLimit())
                && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(sourceVersionNumber(), other.sourceVersionNumber())
                && Objects.equals(operatingSystemAsString(), other.operatingSystemAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContainerGroupDefinitionRequest").add("Name", name())
                .add("GameServerContainerDefinition", gameServerContainerDefinition())
                .add("SupportContainerDefinitions", hasSupportContainerDefinitions() ? supportContainerDefinitions() : null)
                .add("TotalMemoryLimitMebibytes", totalMemoryLimitMebibytes()).add("TotalVcpuLimit", totalVcpuLimit())
                .add("VersionDescription", versionDescription()).add("SourceVersionNumber", sourceVersionNumber())
                .add("OperatingSystem", operatingSystemAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "GameServerContainerDefinition":
            return Optional.ofNullable(clazz.cast(gameServerContainerDefinition()));
        case "SupportContainerDefinitions":
            return Optional.ofNullable(clazz.cast(supportContainerDefinitions()));
        case "TotalMemoryLimitMebibytes":
            return Optional.ofNullable(clazz.cast(totalMemoryLimitMebibytes()));
        case "TotalVcpuLimit":
            return Optional.ofNullable(clazz.cast(totalVcpuLimit()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "SourceVersionNumber":
            return Optional.ofNullable(clazz.cast(sourceVersionNumber()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("GameServerContainerDefinition", GAME_SERVER_CONTAINER_DEFINITION_FIELD);
        map.put("SupportContainerDefinitions", SUPPORT_CONTAINER_DEFINITIONS_FIELD);
        map.put("TotalMemoryLimitMebibytes", TOTAL_MEMORY_LIMIT_MEBIBYTES_FIELD);
        map.put("TotalVcpuLimit", TOTAL_VCPU_LIMIT_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("SourceVersionNumber", SOURCE_VERSION_NUMBER_FIELD);
        map.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContainerGroupDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateContainerGroupDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateContainerGroupDefinitionRequest> {
        /**
         * <p>
         * A descriptive identifier for the container group definition. The name value must be unique in an Amazon Web
         * Services Region.
         * </p>
         * 
         * @param name
         *        A descriptive identifier for the container group definition. The name value must be unique in an
         *        Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An updated definition for the game server container in this group. Define a game server container only when
         * the container group type is <code>GAME_SERVER</code>. You can pass in your container definitions as a JSON
         * file.
         * </p>
         * 
         * @param gameServerContainerDefinition
         *        An updated definition for the game server container in this group. Define a game server container only
         *        when the container group type is <code>GAME_SERVER</code>. You can pass in your container definitions
         *        as a JSON file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerContainerDefinition(GameServerContainerDefinitionInput gameServerContainerDefinition);

        /**
         * <p>
         * An updated definition for the game server container in this group. Define a game server container only when
         * the container group type is <code>GAME_SERVER</code>. You can pass in your container definitions as a JSON
         * file.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GameServerContainerDefinitionInput.Builder} avoiding the need to create one manually via
         * {@link GameServerContainerDefinitionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GameServerContainerDefinitionInput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #gameServerContainerDefinition(GameServerContainerDefinitionInput)}.
         * 
         * @param gameServerContainerDefinition
         *        a consumer that will call methods on {@link GameServerContainerDefinitionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameServerContainerDefinition(GameServerContainerDefinitionInput)
         */
        default Builder gameServerContainerDefinition(
                Consumer<GameServerContainerDefinitionInput.Builder> gameServerContainerDefinition) {
            return gameServerContainerDefinition(GameServerContainerDefinitionInput.builder()
                    .applyMutation(gameServerContainerDefinition).build());
        }

        /**
         * <p>
         * One or more definitions for support containers in this group. You can define a support container in any type
         * of container group. You can pass in your container definitions as a JSON file.
         * </p>
         * 
         * @param supportContainerDefinitions
         *        One or more definitions for support containers in this group. You can define a support container in
         *        any type of container group. You can pass in your container definitions as a JSON file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportContainerDefinitions(Collection<SupportContainerDefinitionInput> supportContainerDefinitions);

        /**
         * <p>
         * One or more definitions for support containers in this group. You can define a support container in any type
         * of container group. You can pass in your container definitions as a JSON file.
         * </p>
         * 
         * @param supportContainerDefinitions
         *        One or more definitions for support containers in this group. You can define a support container in
         *        any type of container group. You can pass in your container definitions as a JSON file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportContainerDefinitions(SupportContainerDefinitionInput... supportContainerDefinitions);

        /**
         * <p>
         * One or more definitions for support containers in this group. You can define a support container in any type
         * of container group. You can pass in your container definitions as a JSON file.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.SupportContainerDefinitionInput.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.gamelift.model.SupportContainerDefinitionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.SupportContainerDefinitionInput.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #supportContainerDefinitions(List<SupportContainerDefinitionInput>)}.
         * 
         * @param supportContainerDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.SupportContainerDefinitionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportContainerDefinitions(java.util.Collection<SupportContainerDefinitionInput>)
         */
        Builder supportContainerDefinitions(Consumer<SupportContainerDefinitionInput.Builder>... supportContainerDefinitions);

        /**
         * <p>
         * The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group share
         * this memory. If you specify memory limits for an individual container, the total value must be greater than
         * any individual container's memory limit.
         * </p>
         * 
         * @param totalMemoryLimitMebibytes
         *        The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group
         *        share this memory. If you specify memory limits for an individual container, the total value must be
         *        greater than any individual container's memory limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalMemoryLimitMebibytes(Integer totalMemoryLimitMebibytes);

        /**
         * <p>
         * The maximum amount of vCPU units to allocate to the container group (1 vCPU is equal to 1024 CPU units). All
         * containers in the group share this memory. If you specify vCPU limits for individual containers, the total
         * value must be equal to or greater than the sum of the CPU limits for all containers in the group.
         * </p>
         * 
         * @param totalVcpuLimit
         *        The maximum amount of vCPU units to allocate to the container group (1 vCPU is equal to 1024 CPU
         *        units). All containers in the group share this memory. If you specify vCPU limits for individual
         *        containers, the total value must be equal to or greater than the sum of the CPU limits for all
         *        containers in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalVcpuLimit(Double totalVcpuLimit);

        /**
         * <p>
         * A description for this update to the container group definition.
         * </p>
         * 
         * @param versionDescription
         *        A description for this update to the container group definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * The container group definition version to update. The new version starts with values from the source version,
         * and then updates values included in this request.
         * </p>
         * 
         * @param sourceVersionNumber
         *        The container group definition version to update. The new version starts with values from the source
         *        version, and then updates values included in this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersionNumber(Integer sourceVersionNumber);

        /**
         * <p>
         * The platform that all containers in the group use. Containers in a group must run on the same operating
         * system.
         * </p>
         * <note>
         * <p>
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a
         * href="http://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a>. For game servers that are hosted
         * on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to
         * server SDK 5.x, and then deploy to AL2023 instances. See <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">
         * Migrate to server SDK version 5.</a>
         * </p>
         * </note>
         * 
         * @param operatingSystem
         *        The platform that all containers in the group use. Containers in a group must run on the same
         *        operating system.</p> <note>
         *        <p>
         *        Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a
         *        href="http://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a>. For game servers that are
         *        hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server
         *        build to server SDK 5.x, and then deploy to AL2023 instances. See <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">
         *        Migrate to server SDK version 5.</a>
         *        </p>
         * @see ContainerOperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerOperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The platform that all containers in the group use. Containers in a group must run on the same operating
         * system.
         * </p>
         * <note>
         * <p>
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a
         * href="http://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a>. For game servers that are hosted
         * on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to
         * server SDK 5.x, and then deploy to AL2023 instances. See <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">
         * Migrate to server SDK version 5.</a>
         * </p>
         * </note>
         * 
         * @param operatingSystem
         *        The platform that all containers in the group use. Containers in a group must run on the same
         *        operating system.</p> <note>
         *        <p>
         *        Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a
         *        href="http://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a>. For game servers that are
         *        hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server
         *        build to server SDK 5.x, and then deploy to AL2023 instances. See <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">
         *        Migrate to server SDK version 5.</a>
         *        </p>
         * @see ContainerOperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerOperatingSystem
         */
        Builder operatingSystem(ContainerOperatingSystem operatingSystem);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String name;

        private GameServerContainerDefinitionInput gameServerContainerDefinition;

        private List<SupportContainerDefinitionInput> supportContainerDefinitions = DefaultSdkAutoConstructList.getInstance();

        private Integer totalMemoryLimitMebibytes;

        private Double totalVcpuLimit;

        private String versionDescription;

        private Integer sourceVersionNumber;

        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContainerGroupDefinitionRequest model) {
            super(model);
            name(model.name);
            gameServerContainerDefinition(model.gameServerContainerDefinition);
            supportContainerDefinitions(model.supportContainerDefinitions);
            totalMemoryLimitMebibytes(model.totalMemoryLimitMebibytes);
            totalVcpuLimit(model.totalVcpuLimit);
            versionDescription(model.versionDescription);
            sourceVersionNumber(model.sourceVersionNumber);
            operatingSystem(model.operatingSystem);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final GameServerContainerDefinitionInput.Builder getGameServerContainerDefinition() {
            return gameServerContainerDefinition != null ? gameServerContainerDefinition.toBuilder() : null;
        }

        public final void setGameServerContainerDefinition(
                GameServerContainerDefinitionInput.BuilderImpl gameServerContainerDefinition) {
            this.gameServerContainerDefinition = gameServerContainerDefinition != null ? gameServerContainerDefinition.build()
                    : null;
        }

        @Override
        public final Builder gameServerContainerDefinition(GameServerContainerDefinitionInput gameServerContainerDefinition) {
            this.gameServerContainerDefinition = gameServerContainerDefinition;
            return this;
        }

        public final List<SupportContainerDefinitionInput.Builder> getSupportContainerDefinitions() {
            List<SupportContainerDefinitionInput.Builder> result = SupportContainerDefinitionInputListCopier
                    .copyToBuilder(this.supportContainerDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportContainerDefinitions(
                Collection<SupportContainerDefinitionInput.BuilderImpl> supportContainerDefinitions) {
            this.supportContainerDefinitions = SupportContainerDefinitionInputListCopier
                    .copyFromBuilder(supportContainerDefinitions);
        }

        @Override
        public final Builder supportContainerDefinitions(Collection<SupportContainerDefinitionInput> supportContainerDefinitions) {
            this.supportContainerDefinitions = SupportContainerDefinitionInputListCopier.copy(supportContainerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportContainerDefinitions(SupportContainerDefinitionInput... supportContainerDefinitions) {
            supportContainerDefinitions(Arrays.asList(supportContainerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportContainerDefinitions(
                Consumer<SupportContainerDefinitionInput.Builder>... supportContainerDefinitions) {
            supportContainerDefinitions(Stream.of(supportContainerDefinitions)
                    .map(c -> SupportContainerDefinitionInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalMemoryLimitMebibytes() {
            return totalMemoryLimitMebibytes;
        }

        public final void setTotalMemoryLimitMebibytes(Integer totalMemoryLimitMebibytes) {
            this.totalMemoryLimitMebibytes = totalMemoryLimitMebibytes;
        }

        @Override
        public final Builder totalMemoryLimitMebibytes(Integer totalMemoryLimitMebibytes) {
            this.totalMemoryLimitMebibytes = totalMemoryLimitMebibytes;
            return this;
        }

        public final Double getTotalVcpuLimit() {
            return totalVcpuLimit;
        }

        public final void setTotalVcpuLimit(Double totalVcpuLimit) {
            this.totalVcpuLimit = totalVcpuLimit;
        }

        @Override
        public final Builder totalVcpuLimit(Double totalVcpuLimit) {
            this.totalVcpuLimit = totalVcpuLimit;
            return this;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final Integer getSourceVersionNumber() {
            return sourceVersionNumber;
        }

        public final void setSourceVersionNumber(Integer sourceVersionNumber) {
            this.sourceVersionNumber = sourceVersionNumber;
        }

        @Override
        public final Builder sourceVersionNumber(Integer sourceVersionNumber) {
            this.sourceVersionNumber = sourceVersionNumber;
            return this;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(ContainerOperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContainerGroupDefinitionRequest build() {
            return new UpdateContainerGroupDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
