/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComputeRequest extends GameLiftRequest implements
        ToCopyableBuilder<ListComputeRequest.Builder, ListComputeRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(ListComputeRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(ListComputeRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContainerGroupDefinitionName")
            .getter(getter(ListComputeRequest::containerGroupDefinitionName))
            .setter(setter(Builder::containerGroupDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitionName")
                    .build()).build();

    private static final SdkField<String> COMPUTE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeStatus").getter(getter(ListComputeRequest::computeStatusAsString))
            .setter(setter(Builder::computeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeStatus").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListComputeRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListComputeRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            LOCATION_FIELD, CONTAINER_GROUP_DEFINITION_NAME_FIELD, COMPUTE_STATUS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fleetId;

    private final String location;

    private final String containerGroupDefinitionName;

    private final String computeStatus;

    private final Integer limit;

    private final String nextToken;

    private ListComputeRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.location = builder.location;
        this.containerGroupDefinitionName = builder.containerGroupDefinitionName;
        this.computeStatus = builder.computeStatus;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for the fleet to retrieve compute resources for.
     * </p>
     * 
     * @return A unique identifier for the fleet to retrieve compute resources for.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The name of a location to retrieve compute resources for. For an Amazon GameLift Servers Anywhere fleet, use a
     * custom location. For a managed fleet, provide a Amazon Web Services Region or Local Zone code (for example:
     * <code>us-west-2</code> or <code>us-west-2-lax-1</code>).
     * </p>
     * 
     * @return The name of a location to retrieve compute resources for. For an Amazon GameLift Servers Anywhere fleet,
     *         use a custom location. For a managed fleet, provide a Amazon Web Services Region or Local Zone code (for
     *         example: <code>us-west-2</code> or <code>us-west-2-lax-1</code>).
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * For computes in a managed container fleet, the name of the deployed container group definition.
     * </p>
     * 
     * @return For computes in a managed container fleet, the name of the deployed container group definition.
     */
    public final String containerGroupDefinitionName() {
        return containerGroupDefinitionName;
    }

    /**
     * <p>
     * The status of computes in a managed container fleet, based on the success of the latest update deployment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> -- The compute is deployed with the correct container definitions. It is ready to process
     * game servers and host game sessions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPAIRED</code> -- An update deployment to the compute failed, and the compute is deployed with incorrect
     * container definitions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeStatus}
     * will return {@link ListComputeInputStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #computeStatusAsString}.
     * </p>
     * 
     * @return The status of computes in a managed container fleet, based on the success of the latest update
     *         deployment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> -- The compute is deployed with the correct container definitions. It is ready to
     *         process game servers and host game sessions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPAIRED</code> -- An update deployment to the compute failed, and the compute is deployed with
     *         incorrect container definitions.
     *         </p>
     *         </li>
     * @see ListComputeInputStatus
     */
    public final ListComputeInputStatus computeStatus() {
        return ListComputeInputStatus.fromValue(computeStatus);
    }

    /**
     * <p>
     * The status of computes in a managed container fleet, based on the success of the latest update deployment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> -- The compute is deployed with the correct container definitions. It is ready to process
     * game servers and host game sessions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPAIRED</code> -- An update deployment to the compute failed, and the compute is deployed with incorrect
     * container definitions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeStatus}
     * will return {@link ListComputeInputStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #computeStatusAsString}.
     * </p>
     * 
     * @return The status of computes in a managed container fleet, based on the success of the latest update
     *         deployment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> -- The compute is deployed with the correct container definitions. It is ready to
     *         process game servers and host game sessions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPAIRED</code> -- An update deployment to the compute failed, and the compute is deployed with
     *         incorrect container definitions.
     *         </p>
     *         </li>
     * @see ListComputeInputStatus
     */
    public final String computeStatusAsString() {
        return computeStatus;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential pages.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @return A token that indicates the start of the next sequential page of results. Use the token that is returned
     *         with a previous call to this operation. To start at the beginning of the result set, do not specify a
     *         value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(containerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(computeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComputeRequest)) {
            return false;
        }
        ListComputeRequest other = (ListComputeRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(location(), other.location())
                && Objects.equals(containerGroupDefinitionName(), other.containerGroupDefinitionName())
                && Objects.equals(computeStatusAsString(), other.computeStatusAsString())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComputeRequest").add("FleetId", fleetId()).add("Location", location())
                .add("ContainerGroupDefinitionName", containerGroupDefinitionName())
                .add("ComputeStatus", computeStatusAsString()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "ContainerGroupDefinitionName":
            return Optional.ofNullable(clazz.cast(containerGroupDefinitionName()));
        case "ComputeStatus":
            return Optional.ofNullable(clazz.cast(computeStatusAsString()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("ContainerGroupDefinitionName", CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("ComputeStatus", COMPUTE_STATUS_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComputeRequest, T> g) {
        return obj -> g.apply((ListComputeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListComputeRequest> {
        /**
         * <p>
         * A unique identifier for the fleet to retrieve compute resources for.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet to retrieve compute resources for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The name of a location to retrieve compute resources for. For an Amazon GameLift Servers Anywhere fleet, use
         * a custom location. For a managed fleet, provide a Amazon Web Services Region or Local Zone code (for example:
         * <code>us-west-2</code> or <code>us-west-2-lax-1</code>).
         * </p>
         * 
         * @param location
         *        The name of a location to retrieve compute resources for. For an Amazon GameLift Servers Anywhere
         *        fleet, use a custom location. For a managed fleet, provide a Amazon Web Services Region or Local Zone
         *        code (for example: <code>us-west-2</code> or <code>us-west-2-lax-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * For computes in a managed container fleet, the name of the deployed container group definition.
         * </p>
         * 
         * @param containerGroupDefinitionName
         *        For computes in a managed container fleet, the name of the deployed container group definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerGroupDefinitionName(String containerGroupDefinitionName);

        /**
         * <p>
         * The status of computes in a managed container fleet, based on the success of the latest update deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> -- The compute is deployed with the correct container definitions. It is ready to process
         * game servers and host game sessions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPAIRED</code> -- An update deployment to the compute failed, and the compute is deployed with
         * incorrect container definitions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param computeStatus
         *        The status of computes in a managed container fleet, based on the success of the latest update
         *        deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> -- The compute is deployed with the correct container definitions. It is ready to
         *        process game servers and host game sessions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPAIRED</code> -- An update deployment to the compute failed, and the compute is deployed with
         *        incorrect container definitions.
         *        </p>
         *        </li>
         * @see ListComputeInputStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListComputeInputStatus
         */
        Builder computeStatus(String computeStatus);

        /**
         * <p>
         * The status of computes in a managed container fleet, based on the success of the latest update deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> -- The compute is deployed with the correct container definitions. It is ready to process
         * game servers and host game sessions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPAIRED</code> -- An update deployment to the compute failed, and the compute is deployed with
         * incorrect container definitions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param computeStatus
         *        The status of computes in a managed container fleet, based on the success of the latest update
         *        deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> -- The compute is deployed with the correct container definitions. It is ready to
         *        process game servers and host game sessions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPAIRED</code> -- An update deployment to the compute failed, and the compute is deployed with
         *        incorrect container definitions.
         *        </p>
         *        </li>
         * @see ListComputeInputStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListComputeInputStatus
         */
        Builder computeStatus(ListComputeInputStatus computeStatus);

        /**
         * <p>
         * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
         * set of sequential pages.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results
         *        as a set of sequential pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with
         * a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the start of the next sequential page of results. Use the token that is
         *        returned with a previous call to this operation. To start at the beginning of the result set, do not
         *        specify a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String location;

        private String containerGroupDefinitionName;

        private String computeStatus;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComputeRequest model) {
            super(model);
            fleetId(model.fleetId);
            location(model.location);
            containerGroupDefinitionName(model.containerGroupDefinitionName);
            computeStatus(model.computeStatus);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getContainerGroupDefinitionName() {
            return containerGroupDefinitionName;
        }

        public final void setContainerGroupDefinitionName(String containerGroupDefinitionName) {
            this.containerGroupDefinitionName = containerGroupDefinitionName;
        }

        @Override
        public final Builder containerGroupDefinitionName(String containerGroupDefinitionName) {
            this.containerGroupDefinitionName = containerGroupDefinitionName;
            return this;
        }

        public final String getComputeStatus() {
            return computeStatus;
        }

        public final void setComputeStatus(String computeStatus) {
            this.computeStatus = computeStatus;
        }

        @Override
        public final Builder computeStatus(String computeStatus) {
            this.computeStatus = computeStatus;
            return this;
        }

        @Override
        public final Builder computeStatus(ListComputeInputStatus computeStatus) {
            this.computeStatus(computeStatus == null ? null : computeStatus.toString());
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListComputeRequest build() {
            return new ListComputeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
