/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number and status of game server container groups that are deployed across a container fleet. Combine this count
 * with the number of server processes that each game server container group runs to learn how many game sessions the
 * fleet is capable of hosting concurrently. For example, if a fleet has 50 game server container groups, and the game
 * server container in each group runs 1 game server process, then the fleet has the capacity to run host 50 game
 * sessions at a time.
 * </p>
 * <p>
 * <b>Returned by:</b> <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html">
 * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html</a>, <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html"
 * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GameServerContainerGroupCounts implements SdkPojo, Serializable,
        ToCopyableBuilder<GameServerContainerGroupCounts.Builder, GameServerContainerGroupCounts> {
    private static final SdkField<Integer> PENDING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PENDING").getter(getter(GameServerContainerGroupCounts::pending)).setter(setter(Builder::pending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PENDING").build()).build();

    private static final SdkField<Integer> ACTIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ACTIVE").getter(getter(GameServerContainerGroupCounts::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACTIVE").build()).build();

    private static final SdkField<Integer> IDLE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("IDLE")
            .getter(getter(GameServerContainerGroupCounts::idle)).setter(setter(Builder::idle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IDLE").build()).build();

    private static final SdkField<Integer> TERMINATING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TERMINATING").getter(getter(GameServerContainerGroupCounts::terminating))
            .setter(setter(Builder::terminating))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TERMINATING").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PENDING_FIELD, ACTIVE_FIELD,
            IDLE_FIELD, TERMINATING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer pending;

    private final Integer active;

    private final Integer idle;

    private final Integer terminating;

    private GameServerContainerGroupCounts(BuilderImpl builder) {
        this.pending = builder.pending;
        this.active = builder.active;
        this.idle = builder.idle;
        this.terminating = builder.terminating;
    }

    /**
     * <p>
     * The number of container groups that are starting up but haven't yet registered.
     * </p>
     * 
     * @return The number of container groups that are starting up but haven't yet registered.
     */
    public final Integer pending() {
        return pending;
    }

    /**
     * <p>
     * The number of container groups that have active game sessions.
     * </p>
     * 
     * @return The number of container groups that have active game sessions.
     */
    public final Integer active() {
        return active;
    }

    /**
     * <p>
     * The number of container groups that have no active game sessions.
     * </p>
     * 
     * @return The number of container groups that have no active game sessions.
     */
    public final Integer idle() {
        return idle;
    }

    /**
     * <p>
     * The number of container groups that are in the process of shutting down.
     * </p>
     * 
     * @return The number of container groups that are in the process of shutting down.
     */
    public final Integer terminating() {
        return terminating;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(idle());
        hashCode = 31 * hashCode + Objects.hashCode(terminating());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameServerContainerGroupCounts)) {
            return false;
        }
        GameServerContainerGroupCounts other = (GameServerContainerGroupCounts) obj;
        return Objects.equals(pending(), other.pending()) && Objects.equals(active(), other.active())
                && Objects.equals(idle(), other.idle()) && Objects.equals(terminating(), other.terminating());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GameServerContainerGroupCounts").add("PENDING", pending()).add("ACTIVE", active())
                .add("IDLE", idle()).add("TERMINATING", terminating()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PENDING":
            return Optional.ofNullable(clazz.cast(pending()));
        case "ACTIVE":
            return Optional.ofNullable(clazz.cast(active()));
        case "IDLE":
            return Optional.ofNullable(clazz.cast(idle()));
        case "TERMINATING":
            return Optional.ofNullable(clazz.cast(terminating()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PENDING", PENDING_FIELD);
        map.put("ACTIVE", ACTIVE_FIELD);
        map.put("IDLE", IDLE_FIELD);
        map.put("TERMINATING", TERMINATING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GameServerContainerGroupCounts, T> g) {
        return obj -> g.apply((GameServerContainerGroupCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GameServerContainerGroupCounts> {
        /**
         * <p>
         * The number of container groups that are starting up but haven't yet registered.
         * </p>
         * 
         * @param pending
         *        The number of container groups that are starting up but haven't yet registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Integer pending);

        /**
         * <p>
         * The number of container groups that have active game sessions.
         * </p>
         * 
         * @param active
         *        The number of container groups that have active game sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Integer active);

        /**
         * <p>
         * The number of container groups that have no active game sessions.
         * </p>
         * 
         * @param idle
         *        The number of container groups that have no active game sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idle(Integer idle);

        /**
         * <p>
         * The number of container groups that are in the process of shutting down.
         * </p>
         * 
         * @param terminating
         *        The number of container groups that are in the process of shutting down.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminating(Integer terminating);
    }

    static final class BuilderImpl implements Builder {
        private Integer pending;

        private Integer active;

        private Integer idle;

        private Integer terminating;

        private BuilderImpl() {
        }

        private BuilderImpl(GameServerContainerGroupCounts model) {
            pending(model.pending);
            active(model.active);
            idle(model.idle);
            terminating(model.terminating);
        }

        public final Integer getPending() {
            return pending;
        }

        public final void setPending(Integer pending) {
            this.pending = pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final Integer getActive() {
            return active;
        }

        public final void setActive(Integer active) {
            this.active = active;
        }

        @Override
        public final Builder active(Integer active) {
            this.active = active;
            return this;
        }

        public final Integer getIdle() {
            return idle;
        }

        public final void setIdle(Integer idle) {
            this.idle = idle;
        }

        @Override
        public final Builder idle(Integer idle) {
            this.idle = idle;
            return this;
        }

        public final Integer getTerminating() {
            return terminating;
        }

        public final void setTerminating(Integer terminating) {
            this.terminating = terminating;
        }

        @Override
        public final Builder terminating(Integer terminating) {
            this.terminating = terminating;
            return this;
        }

        @Override
        public GameServerContainerGroupCounts build() {
            return new GameServerContainerGroupCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
