/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetDeploymentResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeFleetDeploymentResponse.Builder, DescribeFleetDeploymentResponse> {
    private static final SdkField<FleetDeployment> FLEET_DEPLOYMENT_FIELD = SdkField
            .<FleetDeployment> builder(MarshallingType.SDK_POJO).memberName("FleetDeployment")
            .getter(getter(DescribeFleetDeploymentResponse::fleetDeployment)).setter(setter(Builder::fleetDeployment))
            .constructor(FleetDeployment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetDeployment").build()).build();

    private static final SdkField<Map<String, LocationalDeployment>> LOCATIONAL_DEPLOYMENTS_FIELD = SdkField
            .<Map<String, LocationalDeployment>> builder(MarshallingType.MAP)
            .memberName("LocationalDeployments")
            .getter(getter(DescribeFleetDeploymentResponse::locationalDeployments))
            .setter(setter(Builder::locationalDeployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationalDeployments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LocationalDeployment> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationalDeployment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_DEPLOYMENT_FIELD,
            LOCATIONAL_DEPLOYMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final FleetDeployment fleetDeployment;

    private final Map<String, LocationalDeployment> locationalDeployments;

    private DescribeFleetDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.fleetDeployment = builder.fleetDeployment;
        this.locationalDeployments = builder.locationalDeployments;
    }

    /**
     * <p>
     * The requested deployment information.
     * </p>
     * 
     * @return The requested deployment information.
     */
    public final FleetDeployment fleetDeployment() {
        return fleetDeployment;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocationalDeployments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLocationalDeployments() {
        return locationalDeployments != null && !(locationalDeployments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * If the deployment is for a multi-location fleet, the requests returns the deployment status in each fleet
     * location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocationalDeployments} method.
     * </p>
     * 
     * @return If the deployment is for a multi-location fleet, the requests returns the deployment status in each fleet
     *         location.
     */
    public final Map<String, LocationalDeployment> locationalDeployments() {
        return locationalDeployments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocationalDeployments() ? locationalDeployments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetDeploymentResponse)) {
            return false;
        }
        DescribeFleetDeploymentResponse other = (DescribeFleetDeploymentResponse) obj;
        return Objects.equals(fleetDeployment(), other.fleetDeployment())
                && hasLocationalDeployments() == other.hasLocationalDeployments()
                && Objects.equals(locationalDeployments(), other.locationalDeployments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetDeploymentResponse").add("FleetDeployment", fleetDeployment())
                .add("LocationalDeployments", hasLocationalDeployments() ? locationalDeployments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetDeployment":
            return Optional.ofNullable(clazz.cast(fleetDeployment()));
        case "LocationalDeployments":
            return Optional.ofNullable(clazz.cast(locationalDeployments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetDeployment", FLEET_DEPLOYMENT_FIELD);
        map.put("LocationalDeployments", LOCATIONAL_DEPLOYMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetDeploymentResponse, T> g) {
        return obj -> g.apply((DescribeFleetDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFleetDeploymentResponse> {
        /**
         * <p>
         * The requested deployment information.
         * </p>
         * 
         * @param fleetDeployment
         *        The requested deployment information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetDeployment(FleetDeployment fleetDeployment);

        /**
         * <p>
         * The requested deployment information.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetDeployment.Builder} avoiding the
         * need to create one manually via {@link FleetDeployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetDeployment.Builder#build()} is called immediately and its
         * result is passed to {@link #fleetDeployment(FleetDeployment)}.
         * 
         * @param fleetDeployment
         *        a consumer that will call methods on {@link FleetDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetDeployment(FleetDeployment)
         */
        default Builder fleetDeployment(Consumer<FleetDeployment.Builder> fleetDeployment) {
            return fleetDeployment(FleetDeployment.builder().applyMutation(fleetDeployment).build());
        }

        /**
         * <p>
         * If the deployment is for a multi-location fleet, the requests returns the deployment status in each fleet
         * location.
         * </p>
         * 
         * @param locationalDeployments
         *        If the deployment is for a multi-location fleet, the requests returns the deployment status in each
         *        fleet location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationalDeployments(Map<String, LocationalDeployment> locationalDeployments);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private FleetDeployment fleetDeployment;

        private Map<String, LocationalDeployment> locationalDeployments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetDeploymentResponse model) {
            super(model);
            fleetDeployment(model.fleetDeployment);
            locationalDeployments(model.locationalDeployments);
        }

        public final FleetDeployment.Builder getFleetDeployment() {
            return fleetDeployment != null ? fleetDeployment.toBuilder() : null;
        }

        public final void setFleetDeployment(FleetDeployment.BuilderImpl fleetDeployment) {
            this.fleetDeployment = fleetDeployment != null ? fleetDeployment.build() : null;
        }

        @Override
        public final Builder fleetDeployment(FleetDeployment fleetDeployment) {
            this.fleetDeployment = fleetDeployment;
            return this;
        }

        public final Map<String, LocationalDeployment.Builder> getLocationalDeployments() {
            Map<String, LocationalDeployment.Builder> result = LocationalDeploymentsCopier
                    .copyToBuilder(this.locationalDeployments);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLocationalDeployments(Map<String, LocationalDeployment.BuilderImpl> locationalDeployments) {
            this.locationalDeployments = LocationalDeploymentsCopier.copyFromBuilder(locationalDeployments);
        }

        @Override
        public final Builder locationalDeployments(Map<String, LocationalDeployment> locationalDeployments) {
            this.locationalDeployments = LocationalDeploymentsCopier.copy(locationalDeployments);
            return this;
        }

        @Override
        public DescribeFleetDeploymentResponse build() {
            return new DescribeFleetDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
