/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContainerGroupDefinitionResponse extends GameLiftResponse implements
        ToCopyableBuilder<CreateContainerGroupDefinitionResponse.Builder, CreateContainerGroupDefinitionResponse> {
    private static final SdkField<ContainerGroupDefinition> CONTAINER_GROUP_DEFINITION_FIELD = SdkField
            .<ContainerGroupDefinition> builder(MarshallingType.SDK_POJO).memberName("ContainerGroupDefinition")
            .getter(getter(CreateContainerGroupDefinitionResponse::containerGroupDefinition))
            .setter(setter(Builder::containerGroupDefinition)).constructor(ContainerGroupDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONTAINER_GROUP_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ContainerGroupDefinition containerGroupDefinition;

    private CreateContainerGroupDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.containerGroupDefinition = builder.containerGroupDefinition;
    }

    /**
     * <p>
     * The properties of the new container group definition resource. You can use this resource to create a container
     * fleet.
     * </p>
     * 
     * @return The properties of the new container group definition resource. You can use this resource to create a
     *         container fleet.
     */
    public final ContainerGroupDefinition containerGroupDefinition() {
        return containerGroupDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(containerGroupDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerGroupDefinitionResponse)) {
            return false;
        }
        CreateContainerGroupDefinitionResponse other = (CreateContainerGroupDefinitionResponse) obj;
        return Objects.equals(containerGroupDefinition(), other.containerGroupDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContainerGroupDefinitionResponse")
                .add("ContainerGroupDefinition", containerGroupDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerGroupDefinition":
            return Optional.ofNullable(clazz.cast(containerGroupDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContainerGroupDefinition", CONTAINER_GROUP_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerGroupDefinitionResponse, T> g) {
        return obj -> g.apply((CreateContainerGroupDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateContainerGroupDefinitionResponse> {
        /**
         * <p>
         * The properties of the new container group definition resource. You can use this resource to create a
         * container fleet.
         * </p>
         * 
         * @param containerGroupDefinition
         *        The properties of the new container group definition resource. You can use this resource to create a
         *        container fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerGroupDefinition(ContainerGroupDefinition containerGroupDefinition);

        /**
         * <p>
         * The properties of the new container group definition resource. You can use this resource to create a
         * container fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerGroupDefinition.Builder}
         * avoiding the need to create one manually via {@link ContainerGroupDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerGroupDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #containerGroupDefinition(ContainerGroupDefinition)}.
         * 
         * @param containerGroupDefinition
         *        a consumer that will call methods on {@link ContainerGroupDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerGroupDefinition(ContainerGroupDefinition)
         */
        default Builder containerGroupDefinition(Consumer<ContainerGroupDefinition.Builder> containerGroupDefinition) {
            return containerGroupDefinition(ContainerGroupDefinition.builder().applyMutation(containerGroupDefinition).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private ContainerGroupDefinition containerGroupDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerGroupDefinitionResponse model) {
            super(model);
            containerGroupDefinition(model.containerGroupDefinition);
        }

        public final ContainerGroupDefinition.Builder getContainerGroupDefinition() {
            return containerGroupDefinition != null ? containerGroupDefinition.toBuilder() : null;
        }

        public final void setContainerGroupDefinition(ContainerGroupDefinition.BuilderImpl containerGroupDefinition) {
            this.containerGroupDefinition = containerGroupDefinition != null ? containerGroupDefinition.build() : null;
        }

        @Override
        public final Builder containerGroupDefinition(ContainerGroupDefinition containerGroupDefinition) {
            this.containerGroupDefinition = containerGroupDefinition;
            return this;
        }

        @Override
        public CreateContainerGroupDefinitionResponse build() {
            return new CreateContainerGroupDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
