/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a location in a multi-location container fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerFleetLocationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerFleetLocationAttributes.Builder, ContainerFleetLocationAttributes> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(ContainerFleetLocationAttributes::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ContainerFleetLocationAttributes::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String location;

    private final String status;

    private ContainerFleetLocationAttributes(BuilderImpl builder) {
        this.location = builder.location;
        this.status = builder.status;
    }

    /**
     * <p>
     * A location identifier.
     * </p>
     * 
     * @return A location identifier.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The status of fleet activity in the location.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> -- A new container fleet has been requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code> -- A new container fleet resource is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code> -- A new container fleet resource has been created. No fleet instances have been deployed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATING</code> -- New container fleet instances are being deployed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> -- The container fleet has been deployed and is ready to host game sessions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> -- Updates to the container fleet is being updated. A deployment is in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContainerFleetLocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of fleet activity in the location. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> -- A new container fleet has been requested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code> -- A new container fleet resource is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code> -- A new container fleet resource has been created. No fleet instances have been
     *         deployed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code> -- New container fleet instances are being deployed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> -- The container fleet has been deployed and is ready to host game sessions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> -- Updates to the container fleet is being updated. A deployment is in progress.
     *         </p>
     *         </li>
     * @see ContainerFleetLocationStatus
     */
    public final ContainerFleetLocationStatus status() {
        return ContainerFleetLocationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of fleet activity in the location.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> -- A new container fleet has been requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code> -- A new container fleet resource is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code> -- A new container fleet resource has been created. No fleet instances have been deployed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATING</code> -- New container fleet instances are being deployed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> -- The container fleet has been deployed and is ready to host game sessions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> -- Updates to the container fleet is being updated. A deployment is in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContainerFleetLocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of fleet activity in the location. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> -- A new container fleet has been requested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code> -- A new container fleet resource is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code> -- A new container fleet resource has been created. No fleet instances have been
     *         deployed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code> -- New container fleet instances are being deployed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> -- The container fleet has been deployed and is ready to host game sessions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> -- Updates to the container fleet is being updated. A deployment is in progress.
     *         </p>
     *         </li>
     * @see ContainerFleetLocationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerFleetLocationAttributes)) {
            return false;
        }
        ContainerFleetLocationAttributes other = (ContainerFleetLocationAttributes) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerFleetLocationAttributes").add("Location", location()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Location", LOCATION_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerFleetLocationAttributes, T> g) {
        return obj -> g.apply((ContainerFleetLocationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerFleetLocationAttributes> {
        /**
         * <p>
         * A location identifier.
         * </p>
         * 
         * @param location
         *        A location identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The status of fleet activity in the location.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> -- A new container fleet has been requested.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code> -- A new container fleet resource is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code> -- A new container fleet resource has been created. No fleet instances have been
         * deployed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATING</code> -- New container fleet instances are being deployed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> -- The container fleet has been deployed and is ready to host game sessions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> -- Updates to the container fleet is being updated. A deployment is in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of fleet activity in the location. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> -- A new container fleet has been requested.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code> -- A new container fleet resource is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code> -- A new container fleet resource has been created. No fleet instances have been
         *        deployed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code> -- New container fleet instances are being deployed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> -- The container fleet has been deployed and is ready to host game sessions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> -- Updates to the container fleet is being updated. A deployment is in progress.
         *        </p>
         *        </li>
         * @see ContainerFleetLocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFleetLocationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of fleet activity in the location.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> -- A new container fleet has been requested.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code> -- A new container fleet resource is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code> -- A new container fleet resource has been created. No fleet instances have been
         * deployed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATING</code> -- New container fleet instances are being deployed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> -- The container fleet has been deployed and is ready to host game sessions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> -- Updates to the container fleet is being updated. A deployment is in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of fleet activity in the location. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> -- A new container fleet has been requested.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code> -- A new container fleet resource is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code> -- A new container fleet resource has been created. No fleet instances have been
         *        deployed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code> -- New container fleet instances are being deployed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> -- The container fleet has been deployed and is ready to host game sessions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> -- Updates to the container fleet is being updated. A deployment is in progress.
         *        </p>
         *        </li>
         * @see ContainerFleetLocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFleetLocationStatus
         */
        Builder status(ContainerFleetLocationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String location;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerFleetLocationAttributes model) {
            location(model.location);
            status(model.status);
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContainerFleetLocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ContainerFleetLocationAttributes build() {
            return new ContainerFleetLocationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
