/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Values for use in player attribute key-value pairs. This object lets you specify an attribute value using any of the
 * valid data types: string, number, string array, or data map. Each <code>AttributeValue</code> object can use only one
 * of the available properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeValue implements SdkPojo, Serializable, ToCopyableBuilder<AttributeValue.Builder, AttributeValue> {
    private static final SdkField<String> S_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S")
            .getter(getter(AttributeValue::s)).setter(setter(Builder::s))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()).build();

    private static final SdkField<Double> N_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("N")
            .getter(getter(AttributeValue::n)).setter(setter(Builder::n))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("N").build()).build();

    private static final SdkField<List<String>> SL_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SL")
            .getter(getter(AttributeValue::sl))
            .setter(setter(Builder::sl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SL").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Double>> SDM_FIELD = SdkField
            .<Map<String, Double>> builder(MarshallingType.MAP)
            .memberName("SDM")
            .getter(getter(AttributeValue::sdm))
            .setter(setter(Builder::sdm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SDM").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S_FIELD, N_FIELD, SL_FIELD,
            SDM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s;

    private final Double n;

    private final List<String> sl;

    private final Map<String, Double> sdm;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.sl = builder.sl;
        this.sdm = builder.sdm;
    }

    /**
     * <p>
     * For single string values. Maximum string length is 100 characters.
     * </p>
     * 
     * @return For single string values. Maximum string length is 100 characters.
     */
    public final String s() {
        return s;
    }

    /**
     * <p>
     * For number values, expressed as double.
     * </p>
     * 
     * @return For number values, expressed as double.
     */
    public final Double n() {
        return n;
    }

    /**
     * For responses, this returns true if the service returned a value for the SL property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSl() {
        return sl != null && !(sl instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values are not
     * recognized; all occurrences of the repeated value after the first of a repeated value are ignored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSl} method.
     * </p>
     * 
     * @return For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values are
     *         not recognized; all occurrences of the repeated value after the first of a repeated value are ignored.
     */
    public final List<String> sl() {
        return sl;
    }

    /**
     * For responses, this returns true if the service returned a value for the SDM property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSdm() {
        return sdm != null && !(sdm instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * For a map of up to 10 data type:value pairs. Maximum length for each string value is 100 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSdm} method.
     * </p>
     * 
     * @return For a map of up to 10 data type:value pairs. Maximum length for each string value is 100 characters.
     */
    public final Map<String, Double> sdm() {
        return sdm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s());
        hashCode = 31 * hashCode + Objects.hashCode(n());
        hashCode = 31 * hashCode + Objects.hashCode(hasSl() ? sl() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSdm() ? sdm() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue) obj;
        return Objects.equals(s(), other.s()) && Objects.equals(n(), other.n()) && hasSl() == other.hasSl()
                && Objects.equals(sl(), other.sl()) && hasSdm() == other.hasSdm() && Objects.equals(sdm(), other.sdm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeValue").add("S", s()).add("N", n()).add("SL", hasSl() ? sl() : null)
                .add("SDM", hasSdm() ? sdm() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S":
            return Optional.ofNullable(clazz.cast(s()));
        case "N":
            return Optional.ofNullable(clazz.cast(n()));
        case "SL":
            return Optional.ofNullable(clazz.cast(sl()));
        case "SDM":
            return Optional.ofNullable(clazz.cast(sdm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S", S_FIELD);
        map.put("N", N_FIELD);
        map.put("SL", SL_FIELD);
        map.put("SDM", SDM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeValue, T> g) {
        return obj -> g.apply((AttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeValue> {
        /**
         * <p>
         * For single string values. Maximum string length is 100 characters.
         * </p>
         * 
         * @param s
         *        For single string values. Maximum string length is 100 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s(String s);

        /**
         * <p>
         * For number values, expressed as double.
         * </p>
         * 
         * @param n
         *        For number values, expressed as double.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder n(Double n);

        /**
         * <p>
         * For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values are not
         * recognized; all occurrences of the repeated value after the first of a repeated value are ignored.
         * </p>
         * 
         * @param sl
         *        For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values
         *        are not recognized; all occurrences of the repeated value after the first of a repeated value are
         *        ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sl(Collection<String> sl);

        /**
         * <p>
         * For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values are not
         * recognized; all occurrences of the repeated value after the first of a repeated value are ignored.
         * </p>
         * 
         * @param sl
         *        For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values
         *        are not recognized; all occurrences of the repeated value after the first of a repeated value are
         *        ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sl(String... sl);

        /**
         * <p>
         * For a map of up to 10 data type:value pairs. Maximum length for each string value is 100 characters.
         * </p>
         * 
         * @param sdm
         *        For a map of up to 10 data type:value pairs. Maximum length for each string value is 100 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sdm(Map<String, Double> sdm);
    }

    static final class BuilderImpl implements Builder {
        private String s;

        private Double n;

        private List<String> sl = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Double> sdm = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            s(model.s);
            n(model.n);
            sl(model.sl);
            sdm(model.sdm);
        }

        public final String getS() {
            return s;
        }

        public final void setS(String s) {
            this.s = s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final Double getN() {
            return n;
        }

        public final void setN(Double n) {
            this.n = n;
        }

        @Override
        public final Builder n(Double n) {
            this.n = n;
            return this;
        }

        public final Collection<String> getSl() {
            if (sl instanceof SdkAutoConstructList) {
                return null;
            }
            return sl;
        }

        public final void setSl(Collection<String> sl) {
            this.sl = PlayerAttributeStringListCopier.copy(sl);
        }

        @Override
        public final Builder sl(Collection<String> sl) {
            this.sl = PlayerAttributeStringListCopier.copy(sl);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sl(String... sl) {
            sl(Arrays.asList(sl));
            return this;
        }

        public final Map<String, Double> getSdm() {
            if (sdm instanceof SdkAutoConstructMap) {
                return null;
            }
            return sdm;
        }

        public final void setSdm(Map<String, Double> sdm) {
            this.sdm = PlayerAttributeStringDoubleMapCopier.copy(sdm);
        }

        @Override
        public final Builder sdm(Map<String, Double> sdm) {
            this.sdm = PlayerAttributeStringDoubleMapCopier.copy(sdm);
            return this;
        }

        @Override
        public AttributeValue build() {
            return new AttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
