/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.ClaimFilterOption;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClaimGameServerRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, ClaimGameServerRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerGroupName").getter(ClaimGameServerRequest.getter(ClaimGameServerRequest::gameServerGroupName)).setter(ClaimGameServerRequest.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<String> GAME_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerId").getter(ClaimGameServerRequest.getter(ClaimGameServerRequest::gameServerId)).setter(ClaimGameServerRequest.setter(Builder::gameServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerId").build()}).build();
    private static final SdkField<String> GAME_SERVER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerData").getter(ClaimGameServerRequest.getter(ClaimGameServerRequest::gameServerData)).setter(ClaimGameServerRequest.setter(Builder::gameServerData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerData").build()}).build();
    private static final SdkField<ClaimFilterOption> FILTER_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterOption").getter(ClaimGameServerRequest.getter(ClaimGameServerRequest::filterOption)).setter(ClaimGameServerRequest.setter(Builder::filterOption)).constructor(ClaimFilterOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, GAME_SERVER_ID_FIELD, GAME_SERVER_DATA_FIELD, FILTER_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClaimGameServerRequest.memberNameToFieldInitializer();
    private final String gameServerGroupName;
    private final String gameServerId;
    private final String gameServerData;
    private final ClaimFilterOption filterOption;

    private ClaimGameServerRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.gameServerId = builder.gameServerId;
        this.gameServerData = builder.gameServerData;
        this.filterOption = builder.filterOption;
    }

    public final String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public final String gameServerId() {
        return this.gameServerId;
    }

    public final String gameServerData() {
        return this.gameServerData;
    }

    public final ClaimFilterOption filterOption() {
        return this.filterOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerData());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterOption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClaimGameServerRequest)) {
            return false;
        }
        ClaimGameServerRequest other = (ClaimGameServerRequest)((Object)obj);
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(this.gameServerId(), other.gameServerId()) && Objects.equals(this.gameServerData(), other.gameServerData()) && Objects.equals(this.filterOption(), other.filterOption());
    }

    public final String toString() {
        return ToString.builder((String)"ClaimGameServerRequest").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("GameServerId", (Object)this.gameServerId()).add("GameServerData", (Object)this.gameServerData()).add("FilterOption", (Object)this.filterOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "GameServerId": {
                return Optional.ofNullable(clazz.cast(this.gameServerId()));
            }
            case "GameServerData": {
                return Optional.ofNullable(clazz.cast(this.gameServerData()));
            }
            case "FilterOption": {
                return Optional.ofNullable(clazz.cast(this.filterOption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GameServerGroupName", GAME_SERVER_GROUP_NAME_FIELD);
        map.put("GameServerId", GAME_SERVER_ID_FIELD);
        map.put("GameServerData", GAME_SERVER_DATA_FIELD);
        map.put("FilterOption", FILTER_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClaimGameServerRequest, T> g) {
        return obj -> g.apply((ClaimGameServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private String gameServerId;
        private String gameServerData;
        private ClaimFilterOption filterOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ClaimGameServerRequest model) {
            super(model);
            this.gameServerGroupName(model.gameServerGroupName);
            this.gameServerId(model.gameServerId);
            this.gameServerData(model.gameServerData);
            this.filterOption(model.filterOption);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getGameServerId() {
            return this.gameServerId;
        }

        public final void setGameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
        }

        @Override
        public final Builder gameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
            return this;
        }

        public final String getGameServerData() {
            return this.gameServerData;
        }

        public final void setGameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
        }

        @Override
        public final Builder gameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
            return this;
        }

        public final ClaimFilterOption.Builder getFilterOption() {
            return this.filterOption != null ? this.filterOption.toBuilder() : null;
        }

        public final void setFilterOption(ClaimFilterOption.BuilderImpl filterOption) {
            this.filterOption = filterOption != null ? filterOption.build() : null;
        }

        @Override
        public final Builder filterOption(ClaimFilterOption filterOption) {
            this.filterOption = filterOption;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ClaimGameServerRequest build() {
            return new ClaimGameServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ClaimGameServerRequest> {
        public Builder gameServerGroupName(String var1);

        public Builder gameServerId(String var1);

        public Builder gameServerData(String var1);

        public Builder filterOption(ClaimFilterOption var1);

        default public Builder filterOption(Consumer<ClaimFilterOption.Builder> filterOption) {
            return this.filterOption((ClaimFilterOption)((ClaimFilterOption.Builder)ClaimFilterOption.builder().applyMutation(filterOption)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

