/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.LocationOrderOverrideListCopier;
import software.amazon.awssdk.services.gamelift.model.PlacementFallbackStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PriorityConfigurationOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PriorityConfigurationOverride> {
    private static final SdkField<String> PLACEMENT_FALLBACK_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementFallbackStrategy").getter(PriorityConfigurationOverride.getter(PriorityConfigurationOverride::placementFallbackStrategyAsString)).setter(PriorityConfigurationOverride.setter(Builder::placementFallbackStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementFallbackStrategy").build()}).build();
    private static final SdkField<List<String>> LOCATION_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocationOrder").getter(PriorityConfigurationOverride.getter(PriorityConfigurationOverride::locationOrder)).setter(PriorityConfigurationOverride.setter(Builder::locationOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_FALLBACK_STRATEGY_FIELD, LOCATION_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PriorityConfigurationOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String placementFallbackStrategy;
    private final List<String> locationOrder;

    private PriorityConfigurationOverride(BuilderImpl builder) {
        this.placementFallbackStrategy = builder.placementFallbackStrategy;
        this.locationOrder = builder.locationOrder;
    }

    public final PlacementFallbackStrategy placementFallbackStrategy() {
        return PlacementFallbackStrategy.fromValue(this.placementFallbackStrategy);
    }

    public final String placementFallbackStrategyAsString() {
        return this.placementFallbackStrategy;
    }

    public final boolean hasLocationOrder() {
        return this.locationOrder != null && !(this.locationOrder instanceof SdkAutoConstructList);
    }

    public final List<String> locationOrder() {
        return this.locationOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.placementFallbackStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationOrder() ? this.locationOrder() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriorityConfigurationOverride)) {
            return false;
        }
        PriorityConfigurationOverride other = (PriorityConfigurationOverride)obj;
        return Objects.equals(this.placementFallbackStrategyAsString(), other.placementFallbackStrategyAsString()) && this.hasLocationOrder() == other.hasLocationOrder() && Objects.equals(this.locationOrder(), other.locationOrder());
    }

    public final String toString() {
        return ToString.builder((String)"PriorityConfigurationOverride").add("PlacementFallbackStrategy", (Object)this.placementFallbackStrategyAsString()).add("LocationOrder", this.hasLocationOrder() ? this.locationOrder() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlacementFallbackStrategy": {
                return Optional.ofNullable(clazz.cast(this.placementFallbackStrategyAsString()));
            }
            case "LocationOrder": {
                return Optional.ofNullable(clazz.cast(this.locationOrder()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PlacementFallbackStrategy", PLACEMENT_FALLBACK_STRATEGY_FIELD);
        map.put("LocationOrder", LOCATION_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PriorityConfigurationOverride, T> g) {
        return obj -> g.apply((PriorityConfigurationOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String placementFallbackStrategy;
        private List<String> locationOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PriorityConfigurationOverride model) {
            this.placementFallbackStrategy(model.placementFallbackStrategy);
            this.locationOrder(model.locationOrder);
        }

        public final String getPlacementFallbackStrategy() {
            return this.placementFallbackStrategy;
        }

        public final void setPlacementFallbackStrategy(String placementFallbackStrategy) {
            this.placementFallbackStrategy = placementFallbackStrategy;
        }

        @Override
        public final Builder placementFallbackStrategy(String placementFallbackStrategy) {
            this.placementFallbackStrategy = placementFallbackStrategy;
            return this;
        }

        @Override
        public final Builder placementFallbackStrategy(PlacementFallbackStrategy placementFallbackStrategy) {
            this.placementFallbackStrategy(placementFallbackStrategy == null ? null : placementFallbackStrategy.toString());
            return this;
        }

        public final Collection<String> getLocationOrder() {
            if (this.locationOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return this.locationOrder;
        }

        public final void setLocationOrder(Collection<String> locationOrder) {
            this.locationOrder = LocationOrderOverrideListCopier.copy(locationOrder);
        }

        @Override
        public final Builder locationOrder(Collection<String> locationOrder) {
            this.locationOrder = LocationOrderOverrideListCopier.copy(locationOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationOrder(String ... locationOrder) {
            this.locationOrder(Arrays.asList(locationOrder));
            return this;
        }

        public PriorityConfigurationOverride build() {
            return new PriorityConfigurationOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PriorityConfigurationOverride> {
        public Builder placementFallbackStrategy(String var1);

        public Builder placementFallbackStrategy(PlacementFallbackStrategy var1);

        public Builder locationOrder(Collection<String> var1);

        public Builder locationOrder(String ... var1);
    }
}

