/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFleetCapacityResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, UpdateFleetCapacityResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(UpdateFleetCapacityResponse.getter(UpdateFleetCapacityResponse::fleetId)).setter(UpdateFleetCapacityResponse.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(UpdateFleetCapacityResponse.getter(UpdateFleetCapacityResponse::fleetArn)).setter(UpdateFleetCapacityResponse.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(UpdateFleetCapacityResponse.getter(UpdateFleetCapacityResponse::location)).setter(UpdateFleetCapacityResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFleetCapacityResponse.memberNameToFieldInitializer();
    private final String fleetId;
    private final String fleetArn;
    private final String location;

    private UpdateFleetCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.location = builder.location;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetCapacityResponse)) {
            return false;
        }
        UpdateFleetCapacityResponse other = (UpdateFleetCapacityResponse)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFleetCapacityResponse").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("FleetArn", FLEET_ARN_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetCapacityResponse, T> g) {
        return obj -> g.apply((UpdateFleetCapacityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetCapacityResponse model) {
            super(model);
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.location(model.location);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public UpdateFleetCapacityResponse build() {
            return new UpdateFleetCapacityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFleetCapacityResponse> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder location(String var1);
    }
}

