/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameServerGroupDeleteOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteGameServerGroupRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DeleteGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerGroupName").getter(DeleteGameServerGroupRequest.getter(DeleteGameServerGroupRequest::gameServerGroupName)).setter(DeleteGameServerGroupRequest.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<String> DELETE_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeleteOption").getter(DeleteGameServerGroupRequest.getter(DeleteGameServerGroupRequest::deleteOptionAsString)).setter(DeleteGameServerGroupRequest.setter(Builder::deleteOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, DELETE_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteGameServerGroupRequest.memberNameToFieldInitializer();
    private final String gameServerGroupName;
    private final String deleteOption;

    private DeleteGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.deleteOption = builder.deleteOption;
    }

    public final String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public final GameServerGroupDeleteOption deleteOption() {
        return GameServerGroupDeleteOption.fromValue(this.deleteOption);
    }

    public final String deleteOptionAsString() {
        return this.deleteOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGameServerGroupRequest)) {
            return false;
        }
        DeleteGameServerGroupRequest other = (DeleteGameServerGroupRequest)((Object)obj);
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(this.deleteOptionAsString(), other.deleteOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteGameServerGroupRequest").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("DeleteOption", (Object)this.deleteOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "DeleteOption": {
                return Optional.ofNullable(clazz.cast(this.deleteOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GameServerGroupName", GAME_SERVER_GROUP_NAME_FIELD);
        map.put("DeleteOption", DELETE_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteGameServerGroupRequest, T> g) {
        return obj -> g.apply((DeleteGameServerGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private String deleteOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGameServerGroupRequest model) {
            super(model);
            this.gameServerGroupName(model.gameServerGroupName);
            this.deleteOption(model.deleteOption);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getDeleteOption() {
            return this.deleteOption;
        }

        public final void setDeleteOption(String deleteOption) {
            this.deleteOption = deleteOption;
        }

        @Override
        public final Builder deleteOption(String deleteOption) {
            this.deleteOption = deleteOption;
            return this;
        }

        @Override
        public final Builder deleteOption(GameServerGroupDeleteOption deleteOption) {
            this.deleteOption(deleteOption == null ? null : deleteOption.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteGameServerGroupRequest build() {
            return new DeleteGameServerGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteGameServerGroupRequest> {
        public Builder gameServerGroupName(String var1);

        public Builder deleteOption(String var1);

        public Builder deleteOption(GameServerGroupDeleteOption var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

