/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FleetCapacity;
import software.amazon.awssdk.services.gamelift.model.FleetCapacityListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetCapacityResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeFleetCapacityResponse> {
    private static final SdkField<List<FleetCapacity>> FLEET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FleetCapacity").getter(DescribeFleetCapacityResponse.getter(DescribeFleetCapacityResponse::fleetCapacity)).setter(DescribeFleetCapacityResponse.setter(Builder::fleetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetCapacity").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFleetCapacityResponse.getter(DescribeFleetCapacityResponse::nextToken)).setter(DescribeFleetCapacityResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_CAPACITY_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFleetCapacityResponse.memberNameToFieldInitializer();
    private final List<FleetCapacity> fleetCapacity;
    private final String nextToken;

    private DescribeFleetCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.fleetCapacity = builder.fleetCapacity;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFleetCapacity() {
        return this.fleetCapacity != null && !(this.fleetCapacity instanceof SdkAutoConstructList);
    }

    public final List<FleetCapacity> fleetCapacity() {
        return this.fleetCapacity;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetCapacity() ? this.fleetCapacity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetCapacityResponse)) {
            return false;
        }
        DescribeFleetCapacityResponse other = (DescribeFleetCapacityResponse)((Object)obj);
        return this.hasFleetCapacity() == other.hasFleetCapacity() && Objects.equals(this.fleetCapacity(), other.fleetCapacity()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetCapacityResponse").add("FleetCapacity", this.hasFleetCapacity() ? this.fleetCapacity() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetCapacity": {
                return Optional.ofNullable(clazz.cast(this.fleetCapacity()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FleetCapacity", FLEET_CAPACITY_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetCapacityResponse, T> g) {
        return obj -> g.apply((DescribeFleetCapacityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<FleetCapacity> fleetCapacity = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetCapacityResponse model) {
            super(model);
            this.fleetCapacity(model.fleetCapacity);
            this.nextToken(model.nextToken);
        }

        public final List<FleetCapacity.Builder> getFleetCapacity() {
            List<FleetCapacity.Builder> result = FleetCapacityListCopier.copyToBuilder(this.fleetCapacity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetCapacity(Collection<FleetCapacity.BuilderImpl> fleetCapacity) {
            this.fleetCapacity = FleetCapacityListCopier.copyFromBuilder(fleetCapacity);
        }

        @Override
        public final Builder fleetCapacity(Collection<FleetCapacity> fleetCapacity) {
            this.fleetCapacity = FleetCapacityListCopier.copy(fleetCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetCapacity(FleetCapacity ... fleetCapacity) {
            this.fleetCapacity(Arrays.asList(fleetCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetCapacity(Consumer<FleetCapacity.Builder> ... fleetCapacity) {
            this.fleetCapacity(Stream.of(fleetCapacity).map(c -> (FleetCapacity)((FleetCapacity.Builder)FleetCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFleetCapacityResponse build() {
            return new DescribeFleetCapacityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetCapacityResponse> {
        public Builder fleetCapacity(Collection<FleetCapacity> var1);

        public Builder fleetCapacity(FleetCapacity ... var1);

        public Builder fleetCapacity(Consumer<FleetCapacity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

