/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetPortSettingsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeFleetPortSettingsResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(DescribeFleetPortSettingsResponse.getter(DescribeFleetPortSettingsResponse::fleetId)).setter(DescribeFleetPortSettingsResponse.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(DescribeFleetPortSettingsResponse.getter(DescribeFleetPortSettingsResponse::fleetArn)).setter(DescribeFleetPortSettingsResponse.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<List<IpPermission>> INBOUND_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InboundPermissions").getter(DescribeFleetPortSettingsResponse.getter(DescribeFleetPortSettingsResponse::inboundPermissions)).setter(DescribeFleetPortSettingsResponse.setter(Builder::inboundPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(DescribeFleetPortSettingsResponse.getter(DescribeFleetPortSettingsResponse::updateStatusAsString)).setter(DescribeFleetPortSettingsResponse.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(DescribeFleetPortSettingsResponse.getter(DescribeFleetPortSettingsResponse::location)).setter(DescribeFleetPortSettingsResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, INBOUND_PERMISSIONS_FIELD, UPDATE_STATUS_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFleetPortSettingsResponse.memberNameToFieldInitializer();
    private final String fleetId;
    private final String fleetArn;
    private final List<IpPermission> inboundPermissions;
    private final String updateStatus;
    private final String location;

    private DescribeFleetPortSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.inboundPermissions = builder.inboundPermissions;
        this.updateStatus = builder.updateStatus;
        this.location = builder.location;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final boolean hasInboundPermissions() {
        return this.inboundPermissions != null && !(this.inboundPermissions instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> inboundPermissions() {
        return this.inboundPermissions;
    }

    public final LocationUpdateStatus updateStatus() {
        return LocationUpdateStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInboundPermissions() ? this.inboundPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetPortSettingsResponse)) {
            return false;
        }
        DescribeFleetPortSettingsResponse other = (DescribeFleetPortSettingsResponse)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && this.hasInboundPermissions() == other.hasInboundPermissions() && Objects.equals(this.inboundPermissions(), other.inboundPermissions()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetPortSettingsResponse").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("InboundPermissions", this.hasInboundPermissions() ? this.inboundPermissions() : null).add("UpdateStatus", (Object)this.updateStatusAsString()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "InboundPermissions": {
                return Optional.ofNullable(clazz.cast(this.inboundPermissions()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("FleetArn", FLEET_ARN_FIELD);
        map.put("InboundPermissions", INBOUND_PERMISSIONS_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetPortSettingsResponse, T> g) {
        return obj -> g.apply((DescribeFleetPortSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private List<IpPermission> inboundPermissions = DefaultSdkAutoConstructList.getInstance();
        private String updateStatus;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetPortSettingsResponse model) {
            super(model);
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.inboundPermissions(model.inboundPermissions);
            this.updateStatus(model.updateStatus);
            this.location(model.location);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final List<IpPermission.Builder> getInboundPermissions() {
            List<IpPermission.Builder> result = IpPermissionsListCopier.copyToBuilder(this.inboundPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInboundPermissions(Collection<IpPermission.BuilderImpl> inboundPermissions) {
            this.inboundPermissions = IpPermissionsListCopier.copyFromBuilder(inboundPermissions);
        }

        @Override
        public final Builder inboundPermissions(Collection<IpPermission> inboundPermissions) {
            this.inboundPermissions = IpPermissionsListCopier.copy(inboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissions(IpPermission ... inboundPermissions) {
            this.inboundPermissions(Arrays.asList(inboundPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissions(Consumer<IpPermission.Builder> ... inboundPermissions) {
            this.inboundPermissions(Stream.of(inboundPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(LocationUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public DescribeFleetPortSettingsResponse build() {
            return new DescribeFleetPortSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetPortSettingsResponse> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder inboundPermissions(Collection<IpPermission> var1);

        public Builder inboundPermissions(IpPermission ... var1);

        public Builder inboundPermissions(Consumer<IpPermission.Builder> ... var1);

        public Builder updateStatus(String var1);

        public Builder updateStatus(LocationUpdateStatus var1);

        public Builder location(String var1);
    }
}

