/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ContainerFleet;
import software.amazon.awssdk.services.gamelift.model.ContainerFleetListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContainerFleetsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, ListContainerFleetsResponse> {
    private static final SdkField<List<ContainerFleet>> CONTAINER_FLEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerFleets").getter(ListContainerFleetsResponse.getter(ListContainerFleetsResponse::containerFleets)).setter(ListContainerFleetsResponse.setter(Builder::containerFleets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerFleets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerFleet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListContainerFleetsResponse.getter(ListContainerFleetsResponse::nextToken)).setter(ListContainerFleetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FLEETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListContainerFleetsResponse.memberNameToFieldInitializer();
    private final List<ContainerFleet> containerFleets;
    private final String nextToken;

    private ListContainerFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.containerFleets = builder.containerFleets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContainerFleets() {
        return this.containerFleets != null && !(this.containerFleets instanceof SdkAutoConstructList);
    }

    public final List<ContainerFleet> containerFleets() {
        return this.containerFleets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerFleets() ? this.containerFleets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContainerFleetsResponse)) {
            return false;
        }
        ListContainerFleetsResponse other = (ListContainerFleetsResponse)((Object)obj);
        return this.hasContainerFleets() == other.hasContainerFleets() && Objects.equals(this.containerFleets(), other.containerFleets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContainerFleetsResponse").add("ContainerFleets", this.hasContainerFleets() ? this.containerFleets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerFleets": {
                return Optional.ofNullable(clazz.cast(this.containerFleets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContainerFleets", CONTAINER_FLEETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContainerFleetsResponse, T> g) {
        return obj -> g.apply((ListContainerFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<ContainerFleet> containerFleets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContainerFleetsResponse model) {
            super(model);
            this.containerFleets(model.containerFleets);
            this.nextToken(model.nextToken);
        }

        public final List<ContainerFleet.Builder> getContainerFleets() {
            List<ContainerFleet.Builder> result = ContainerFleetListCopier.copyToBuilder(this.containerFleets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerFleets(Collection<ContainerFleet.BuilderImpl> containerFleets) {
            this.containerFleets = ContainerFleetListCopier.copyFromBuilder(containerFleets);
        }

        @Override
        public final Builder containerFleets(Collection<ContainerFleet> containerFleets) {
            this.containerFleets = ContainerFleetListCopier.copy(containerFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerFleets(ContainerFleet ... containerFleets) {
            this.containerFleets(Arrays.asList(containerFleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerFleets(Consumer<ContainerFleet.Builder> ... containerFleets) {
            this.containerFleets(Stream.of(containerFleets).map(c -> (ContainerFleet)((ContainerFleet.Builder)ContainerFleet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContainerFleetsResponse build() {
            return new ListContainerFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContainerFleetsResponse> {
        public Builder containerFleets(Collection<ContainerFleet> var1);

        public Builder containerFleets(ContainerFleet ... var1);

        public Builder containerFleets(Consumer<ContainerFleet.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

