/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.model.ReplicaContainerGroupCounts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetCapacity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetCapacity> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(FleetCapacity.getter(FleetCapacity::fleetId)).setter(FleetCapacity.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(FleetCapacity.getter(FleetCapacity::fleetArn)).setter(FleetCapacity.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(FleetCapacity.getter(FleetCapacity::instanceTypeAsString)).setter(FleetCapacity.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<EC2InstanceCounts> INSTANCE_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceCounts").getter(FleetCapacity.getter(FleetCapacity::instanceCounts)).setter(FleetCapacity.setter(Builder::instanceCounts)).constructor(EC2InstanceCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCounts").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(FleetCapacity.getter(FleetCapacity::location)).setter(FleetCapacity.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<ReplicaContainerGroupCounts> REPLICA_CONTAINER_GROUP_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicaContainerGroupCounts").getter(FleetCapacity.getter(FleetCapacity::replicaContainerGroupCounts)).setter(FleetCapacity.setter(Builder::replicaContainerGroupCounts)).constructor(ReplicaContainerGroupCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaContainerGroupCounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_COUNTS_FIELD, LOCATION_FIELD, REPLICA_CONTAINER_GROUP_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FleetId", FLEET_ID_FIELD);
            this.put("FleetArn", FLEET_ARN_FIELD);
            this.put("InstanceType", INSTANCE_TYPE_FIELD);
            this.put("InstanceCounts", INSTANCE_COUNTS_FIELD);
            this.put("Location", LOCATION_FIELD);
            this.put("ReplicaContainerGroupCounts", REPLICA_CONTAINER_GROUP_COUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fleetId;
    private final String fleetArn;
    private final String instanceType;
    private final EC2InstanceCounts instanceCounts;
    private final String location;
    private final ReplicaContainerGroupCounts replicaContainerGroupCounts;

    private FleetCapacity(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.instanceType = builder.instanceType;
        this.instanceCounts = builder.instanceCounts;
        this.location = builder.location;
        this.replicaContainerGroupCounts = builder.replicaContainerGroupCounts;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final EC2InstanceType instanceType() {
        return EC2InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final EC2InstanceCounts instanceCounts() {
        return this.instanceCounts;
    }

    public final String location() {
        return this.location;
    }

    public final ReplicaContainerGroupCounts replicaContainerGroupCounts() {
        return this.replicaContainerGroupCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaContainerGroupCounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetCapacity)) {
            return false;
        }
        FleetCapacity other = (FleetCapacity)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.instanceCounts(), other.instanceCounts()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.replicaContainerGroupCounts(), other.replicaContainerGroupCounts());
    }

    public final String toString() {
        return ToString.builder((String)"FleetCapacity").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("InstanceType", (Object)this.instanceTypeAsString()).add("InstanceCounts", (Object)this.instanceCounts()).add("Location", (Object)this.location()).add("ReplicaContainerGroupCounts", (Object)this.replicaContainerGroupCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InstanceCounts": {
                return Optional.ofNullable(clazz.cast(this.instanceCounts()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "ReplicaContainerGroupCounts": {
                return Optional.ofNullable(clazz.cast(this.replicaContainerGroupCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FleetCapacity, T> g) {
        return obj -> g.apply((FleetCapacity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String instanceType;
        private EC2InstanceCounts instanceCounts;
        private String location;
        private ReplicaContainerGroupCounts replicaContainerGroupCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetCapacity model) {
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.instanceType(model.instanceType);
            this.instanceCounts(model.instanceCounts);
            this.location(model.location);
            this.replicaContainerGroupCounts(model.replicaContainerGroupCounts);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(EC2InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final EC2InstanceCounts.Builder getInstanceCounts() {
            return this.instanceCounts != null ? this.instanceCounts.toBuilder() : null;
        }

        public final void setInstanceCounts(EC2InstanceCounts.BuilderImpl instanceCounts) {
            this.instanceCounts = instanceCounts != null ? instanceCounts.build() : null;
        }

        @Override
        public final Builder instanceCounts(EC2InstanceCounts instanceCounts) {
            this.instanceCounts = instanceCounts;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final ReplicaContainerGroupCounts.Builder getReplicaContainerGroupCounts() {
            return this.replicaContainerGroupCounts != null ? this.replicaContainerGroupCounts.toBuilder() : null;
        }

        public final void setReplicaContainerGroupCounts(ReplicaContainerGroupCounts.BuilderImpl replicaContainerGroupCounts) {
            this.replicaContainerGroupCounts = replicaContainerGroupCounts != null ? replicaContainerGroupCounts.build() : null;
        }

        @Override
        public final Builder replicaContainerGroupCounts(ReplicaContainerGroupCounts replicaContainerGroupCounts) {
            this.replicaContainerGroupCounts = replicaContainerGroupCounts;
            return this;
        }

        public FleetCapacity build() {
            return new FleetCapacity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetCapacity> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(EC2InstanceType var1);

        public Builder instanceCounts(EC2InstanceCounts var1);

        default public Builder instanceCounts(Consumer<EC2InstanceCounts.Builder> instanceCounts) {
            return this.instanceCounts((EC2InstanceCounts)((EC2InstanceCounts.Builder)EC2InstanceCounts.builder().applyMutation(instanceCounts)).build());
        }

        public Builder location(String var1);

        public Builder replicaContainerGroupCounts(ReplicaContainerGroupCounts var1);

        default public Builder replicaContainerGroupCounts(Consumer<ReplicaContainerGroupCounts.Builder> replicaContainerGroupCounts) {
            return this.replicaContainerGroupCounts((ReplicaContainerGroupCounts)((ReplicaContainerGroupCounts.Builder)ReplicaContainerGroupCounts.builder().applyMutation(replicaContainerGroupCounts)).build());
        }
    }
}

