/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.ComputeStatus;
import software.amazon.awssdk.services.gamelift.model.ContainerAttributes;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Compute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Compute> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(Compute.getter(Compute::fleetId)).setter(Compute.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(Compute.getter(Compute::fleetArn)).setter(Compute.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> COMPUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeName").getter(Compute.getter(Compute::computeName)).setter(Compute.setter(Builder::computeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeName").build()}).build();
    private static final SdkField<String> COMPUTE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeArn").getter(Compute.getter(Compute::computeArn)).setter(Compute.setter(Builder::computeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeArn").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(Compute.getter(Compute::ipAddress)).setter(Compute.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(Compute.getter(Compute::dnsName)).setter(Compute.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<String> COMPUTE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeStatus").getter(Compute.getter(Compute::computeStatusAsString)).setter(Compute.setter(Builder::computeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeStatus").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(Compute.getter(Compute::location)).setter(Compute.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Compute.getter(Compute::creationTime)).setter(Compute.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(Compute.getter(Compute::operatingSystemAsString)).setter(Compute.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Compute.getter(Compute::typeAsString)).setter(Compute.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> GAME_LIFT_SERVICE_SDK_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameLiftServiceSdkEndpoint").getter(Compute.getter(Compute::gameLiftServiceSdkEndpoint)).setter(Compute.setter(Builder::gameLiftServiceSdkEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameLiftServiceSdkEndpoint").build()}).build();
    private static final SdkField<String> GAME_LIFT_AGENT_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameLiftAgentEndpoint").getter(Compute.getter(Compute::gameLiftAgentEndpoint)).setter(Compute.setter(Builder::gameLiftAgentEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameLiftAgentEndpoint").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(Compute.getter(Compute::instanceId)).setter(Compute.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<ContainerAttributes> CONTAINER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerAttributes").getter(Compute.getter(Compute::containerAttributes)).setter(Compute.setter(Builder::containerAttributes)).constructor(ContainerAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, COMPUTE_NAME_FIELD, COMPUTE_ARN_FIELD, IP_ADDRESS_FIELD, DNS_NAME_FIELD, COMPUTE_STATUS_FIELD, LOCATION_FIELD, CREATION_TIME_FIELD, OPERATING_SYSTEM_FIELD, TYPE_FIELD, GAME_LIFT_SERVICE_SDK_ENDPOINT_FIELD, GAME_LIFT_AGENT_ENDPOINT_FIELD, INSTANCE_ID_FIELD, CONTAINER_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FleetId", FLEET_ID_FIELD);
            this.put("FleetArn", FLEET_ARN_FIELD);
            this.put("ComputeName", COMPUTE_NAME_FIELD);
            this.put("ComputeArn", COMPUTE_ARN_FIELD);
            this.put("IpAddress", IP_ADDRESS_FIELD);
            this.put("DnsName", DNS_NAME_FIELD);
            this.put("ComputeStatus", COMPUTE_STATUS_FIELD);
            this.put("Location", LOCATION_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("GameLiftServiceSdkEndpoint", GAME_LIFT_SERVICE_SDK_ENDPOINT_FIELD);
            this.put("GameLiftAgentEndpoint", GAME_LIFT_AGENT_ENDPOINT_FIELD);
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("ContainerAttributes", CONTAINER_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fleetId;
    private final String fleetArn;
    private final String computeName;
    private final String computeArn;
    private final String ipAddress;
    private final String dnsName;
    private final String computeStatus;
    private final String location;
    private final Instant creationTime;
    private final String operatingSystem;
    private final String type;
    private final String gameLiftServiceSdkEndpoint;
    private final String gameLiftAgentEndpoint;
    private final String instanceId;
    private final ContainerAttributes containerAttributes;

    private Compute(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.computeName = builder.computeName;
        this.computeArn = builder.computeArn;
        this.ipAddress = builder.ipAddress;
        this.dnsName = builder.dnsName;
        this.computeStatus = builder.computeStatus;
        this.location = builder.location;
        this.creationTime = builder.creationTime;
        this.operatingSystem = builder.operatingSystem;
        this.type = builder.type;
        this.gameLiftServiceSdkEndpoint = builder.gameLiftServiceSdkEndpoint;
        this.gameLiftAgentEndpoint = builder.gameLiftAgentEndpoint;
        this.instanceId = builder.instanceId;
        this.containerAttributes = builder.containerAttributes;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final String computeName() {
        return this.computeName;
    }

    public final String computeArn() {
        return this.computeArn;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final ComputeStatus computeStatus() {
        return ComputeStatus.fromValue(this.computeStatus);
    }

    public final String computeStatusAsString() {
        return this.computeStatus;
    }

    public final String location() {
        return this.location;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final EC2InstanceType type() {
        return EC2InstanceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String gameLiftServiceSdkEndpoint() {
        return this.gameLiftServiceSdkEndpoint;
    }

    public final String gameLiftAgentEndpoint() {
        return this.gameLiftAgentEndpoint;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final ContainerAttributes containerAttributes() {
        return this.containerAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameLiftServiceSdkEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameLiftAgentEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compute)) {
            return false;
        }
        Compute other = (Compute)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.computeName(), other.computeName()) && Objects.equals(this.computeArn(), other.computeArn()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.computeStatusAsString(), other.computeStatusAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.gameLiftServiceSdkEndpoint(), other.gameLiftServiceSdkEndpoint()) && Objects.equals(this.gameLiftAgentEndpoint(), other.gameLiftAgentEndpoint()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.containerAttributes(), other.containerAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"Compute").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("ComputeName", (Object)this.computeName()).add("ComputeArn", (Object)this.computeArn()).add("IpAddress", (Object)(this.ipAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("DnsName", (Object)this.dnsName()).add("ComputeStatus", (Object)this.computeStatusAsString()).add("Location", (Object)this.location()).add("CreationTime", (Object)this.creationTime()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("Type", (Object)this.typeAsString()).add("GameLiftServiceSdkEndpoint", (Object)this.gameLiftServiceSdkEndpoint()).add("GameLiftAgentEndpoint", (Object)this.gameLiftAgentEndpoint()).add("InstanceId", (Object)this.instanceId()).add("ContainerAttributes", (Object)this.containerAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "ComputeName": {
                return Optional.ofNullable(clazz.cast(this.computeName()));
            }
            case "ComputeArn": {
                return Optional.ofNullable(clazz.cast(this.computeArn()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "ComputeStatus": {
                return Optional.ofNullable(clazz.cast(this.computeStatusAsString()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "GameLiftServiceSdkEndpoint": {
                return Optional.ofNullable(clazz.cast(this.gameLiftServiceSdkEndpoint()));
            }
            case "GameLiftAgentEndpoint": {
                return Optional.ofNullable(clazz.cast(this.gameLiftAgentEndpoint()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContainerAttributes": {
                return Optional.ofNullable(clazz.cast(this.containerAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Compute, T> g) {
        return obj -> g.apply((Compute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String computeName;
        private String computeArn;
        private String ipAddress;
        private String dnsName;
        private String computeStatus;
        private String location;
        private Instant creationTime;
        private String operatingSystem;
        private String type;
        private String gameLiftServiceSdkEndpoint;
        private String gameLiftAgentEndpoint;
        private String instanceId;
        private ContainerAttributes containerAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(Compute model) {
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.computeName(model.computeName);
            this.computeArn(model.computeArn);
            this.ipAddress(model.ipAddress);
            this.dnsName(model.dnsName);
            this.computeStatus(model.computeStatus);
            this.location(model.location);
            this.creationTime(model.creationTime);
            this.operatingSystem(model.operatingSystem);
            this.type(model.type);
            this.gameLiftServiceSdkEndpoint(model.gameLiftServiceSdkEndpoint);
            this.gameLiftAgentEndpoint(model.gameLiftAgentEndpoint);
            this.instanceId(model.instanceId);
            this.containerAttributes(model.containerAttributes);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getComputeName() {
            return this.computeName;
        }

        public final void setComputeName(String computeName) {
            this.computeName = computeName;
        }

        @Override
        public final Builder computeName(String computeName) {
            this.computeName = computeName;
            return this;
        }

        public final String getComputeArn() {
            return this.computeArn;
        }

        public final void setComputeArn(String computeArn) {
            this.computeArn = computeArn;
        }

        @Override
        public final Builder computeArn(String computeArn) {
            this.computeArn = computeArn;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getComputeStatus() {
            return this.computeStatus;
        }

        public final void setComputeStatus(String computeStatus) {
            this.computeStatus = computeStatus;
        }

        @Override
        public final Builder computeStatus(String computeStatus) {
            this.computeStatus = computeStatus;
            return this;
        }

        @Override
        public final Builder computeStatus(ComputeStatus computeStatus) {
            this.computeStatus(computeStatus == null ? null : computeStatus.toString());
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EC2InstanceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getGameLiftServiceSdkEndpoint() {
            return this.gameLiftServiceSdkEndpoint;
        }

        public final void setGameLiftServiceSdkEndpoint(String gameLiftServiceSdkEndpoint) {
            this.gameLiftServiceSdkEndpoint = gameLiftServiceSdkEndpoint;
        }

        @Override
        public final Builder gameLiftServiceSdkEndpoint(String gameLiftServiceSdkEndpoint) {
            this.gameLiftServiceSdkEndpoint = gameLiftServiceSdkEndpoint;
            return this;
        }

        public final String getGameLiftAgentEndpoint() {
            return this.gameLiftAgentEndpoint;
        }

        public final void setGameLiftAgentEndpoint(String gameLiftAgentEndpoint) {
            this.gameLiftAgentEndpoint = gameLiftAgentEndpoint;
        }

        @Override
        public final Builder gameLiftAgentEndpoint(String gameLiftAgentEndpoint) {
            this.gameLiftAgentEndpoint = gameLiftAgentEndpoint;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final ContainerAttributes.Builder getContainerAttributes() {
            return this.containerAttributes != null ? this.containerAttributes.toBuilder() : null;
        }

        public final void setContainerAttributes(ContainerAttributes.BuilderImpl containerAttributes) {
            this.containerAttributes = containerAttributes != null ? containerAttributes.build() : null;
        }

        @Override
        public final Builder containerAttributes(ContainerAttributes containerAttributes) {
            this.containerAttributes = containerAttributes;
            return this;
        }

        public Compute build() {
            return new Compute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Compute> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder computeName(String var1);

        public Builder computeArn(String var1);

        public Builder ipAddress(String var1);

        public Builder dnsName(String var1);

        public Builder computeStatus(String var1);

        public Builder computeStatus(ComputeStatus var1);

        public Builder location(String var1);

        public Builder creationTime(Instant var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder type(String var1);

        public Builder type(EC2InstanceType var1);

        public Builder gameLiftServiceSdkEndpoint(String var1);

        public Builder gameLiftAgentEndpoint(String var1);

        public Builder instanceId(String var1);

        public Builder containerAttributes(ContainerAttributes var1);

        default public Builder containerAttributes(Consumer<ContainerAttributes.Builder> containerAttributes) {
            return this.containerAttributes((ContainerAttributes)((ContainerAttributes.Builder)ContainerAttributes.builder().applyMutation(containerAttributes)).build());
        }
    }
}

