/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.Credentials;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestUploadCredentialsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, RequestUploadCredentialsResponse> {
    private static final SdkField<Credentials> UPLOAD_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UploadCredentials").getter(RequestUploadCredentialsResponse.getter(RequestUploadCredentialsResponse::uploadCredentials)).setter(RequestUploadCredentialsResponse.setter(Builder::uploadCredentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadCredentials").build()}).build();
    private static final SdkField<S3Location> STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageLocation").getter(RequestUploadCredentialsResponse.getter(RequestUploadCredentialsResponse::storageLocation)).setter(RequestUploadCredentialsResponse.setter(Builder::storageLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_CREDENTIALS_FIELD, STORAGE_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RequestUploadCredentialsResponse.memberNameToFieldInitializer();
    private final Credentials uploadCredentials;
    private final S3Location storageLocation;

    private RequestUploadCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.uploadCredentials = builder.uploadCredentials;
        this.storageLocation = builder.storageLocation;
    }

    public final Credentials uploadCredentials() {
        return this.uploadCredentials;
    }

    public final S3Location storageLocation() {
        return this.storageLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestUploadCredentialsResponse)) {
            return false;
        }
        RequestUploadCredentialsResponse other = (RequestUploadCredentialsResponse)((Object)obj);
        return Objects.equals(this.uploadCredentials(), other.uploadCredentials()) && Objects.equals(this.storageLocation(), other.storageLocation());
    }

    public final String toString() {
        return ToString.builder((String)"RequestUploadCredentialsResponse").add("UploadCredentials", (Object)(this.uploadCredentials() == null ? null : "*** Sensitive Data Redacted ***")).add("StorageLocation", (Object)this.storageLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UploadCredentials": {
                return Optional.ofNullable(clazz.cast(this.uploadCredentials()));
            }
            case "StorageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UploadCredentials", UPLOAD_CREDENTIALS_FIELD);
        map.put("StorageLocation", STORAGE_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestUploadCredentialsResponse, T> g) {
        return obj -> g.apply((RequestUploadCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private Credentials uploadCredentials;
        private S3Location storageLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestUploadCredentialsResponse model) {
            super(model);
            this.uploadCredentials(model.uploadCredentials);
            this.storageLocation(model.storageLocation);
        }

        public final Credentials.Builder getUploadCredentials() {
            return this.uploadCredentials != null ? this.uploadCredentials.toBuilder() : null;
        }

        public final void setUploadCredentials(Credentials.BuilderImpl uploadCredentials) {
            this.uploadCredentials = uploadCredentials != null ? uploadCredentials.build() : null;
        }

        @Override
        public final Builder uploadCredentials(Credentials uploadCredentials) {
            this.uploadCredentials = uploadCredentials;
            return this;
        }

        public final S3Location.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(S3Location.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        @Override
        public RequestUploadCredentialsResponse build() {
            return new RequestUploadCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RequestUploadCredentialsResponse> {
        public Builder uploadCredentials(Credentials var1);

        default public Builder uploadCredentials(Consumer<Credentials.Builder> uploadCredentials) {
            return this.uploadCredentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(uploadCredentials)).build());
        }

        public Builder storageLocation(S3Location var1);

        default public Builder storageLocation(Consumer<S3Location.Builder> storageLocation) {
            return this.storageLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(storageLocation)).build());
        }
    }
}

