/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState;
import software.amazon.awssdk.services.gamelift.model.PlacedPlayerSession;
import software.amazon.awssdk.services.gamelift.model.PlacedPlayerSessionListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerLatency;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GameSessionPlacement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GameSessionPlacement> {
    private static final SdkField<String> PLACEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementId").getter(GameSessionPlacement.getter(GameSessionPlacement::placementId)).setter(GameSessionPlacement.setter(Builder::placementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementId").build()}).build();
    private static final SdkField<String> GAME_SESSION_QUEUE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionQueueName").getter(GameSessionPlacement.getter(GameSessionPlacement::gameSessionQueueName)).setter(GameSessionPlacement.setter(Builder::gameSessionQueueName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionQueueName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GameSessionPlacement.getter(GameSessionPlacement::statusAsString)).setter(GameSessionPlacement.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameProperties").getter(GameSessionPlacement.getter(GameSessionPlacement::gameProperties)).setter(GameSessionPlacement.setter(Builder::gameProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumPlayerSessionCount").getter(GameSessionPlacement.getter(GameSessionPlacement::maximumPlayerSessionCount)).setter(GameSessionPlacement.setter(Builder::maximumPlayerSessionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build()}).build();
    private static final SdkField<String> GAME_SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionName").getter(GameSessionPlacement.getter(GameSessionPlacement::gameSessionName)).setter(GameSessionPlacement.setter(Builder::gameSessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionName").build()}).build();
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionId").getter(GameSessionPlacement.getter(GameSessionPlacement::gameSessionId)).setter(GameSessionPlacement.setter(Builder::gameSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()}).build();
    private static final SdkField<String> GAME_SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionArn").getter(GameSessionPlacement.getter(GameSessionPlacement::gameSessionArn)).setter(GameSessionPlacement.setter(Builder::gameSessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionArn").build()}).build();
    private static final SdkField<String> GAME_SESSION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionRegion").getter(GameSessionPlacement.getter(GameSessionPlacement::gameSessionRegion)).setter(GameSessionPlacement.setter(Builder::gameSessionRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionRegion").build()}).build();
    private static final SdkField<List<PlayerLatency>> PLAYER_LATENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlayerLatencies").getter(GameSessionPlacement.getter(GameSessionPlacement::playerLatencies)).setter(GameSessionPlacement.setter(Builder::playerLatencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerLatencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlayerLatency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GameSessionPlacement.getter(GameSessionPlacement::startTime)).setter(GameSessionPlacement.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GameSessionPlacement.getter(GameSessionPlacement::endTime)).setter(GameSessionPlacement.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(GameSessionPlacement.getter(GameSessionPlacement::ipAddress)).setter(GameSessionPlacement.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(GameSessionPlacement.getter(GameSessionPlacement::dnsName)).setter(GameSessionPlacement.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(GameSessionPlacement.getter(GameSessionPlacement::port)).setter(GameSessionPlacement.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<List<PlacedPlayerSession>> PLACED_PLAYER_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlacedPlayerSessions").getter(GameSessionPlacement.getter(GameSessionPlacement::placedPlayerSessions)).setter(GameSessionPlacement.setter(Builder::placedPlayerSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacedPlayerSessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacedPlayerSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GAME_SESSION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionData").getter(GameSessionPlacement.getter(GameSessionPlacement::gameSessionData)).setter(GameSessionPlacement.setter(Builder::gameSessionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionData").build()}).build();
    private static final SdkField<String> MATCHMAKER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchmakerData").getter(GameSessionPlacement.getter(GameSessionPlacement::matchmakerData)).setter(GameSessionPlacement.setter(Builder::matchmakerData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchmakerData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_ID_FIELD, GAME_SESSION_QUEUE_NAME_FIELD, STATUS_FIELD, GAME_PROPERTIES_FIELD, MAXIMUM_PLAYER_SESSION_COUNT_FIELD, GAME_SESSION_NAME_FIELD, GAME_SESSION_ID_FIELD, GAME_SESSION_ARN_FIELD, GAME_SESSION_REGION_FIELD, PLAYER_LATENCIES_FIELD, START_TIME_FIELD, END_TIME_FIELD, IP_ADDRESS_FIELD, DNS_NAME_FIELD, PORT_FIELD, PLACED_PLAYER_SESSIONS_FIELD, GAME_SESSION_DATA_FIELD, MATCHMAKER_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PlacementId", PLACEMENT_ID_FIELD);
            this.put("GameSessionQueueName", GAME_SESSION_QUEUE_NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("GameProperties", GAME_PROPERTIES_FIELD);
            this.put("MaximumPlayerSessionCount", MAXIMUM_PLAYER_SESSION_COUNT_FIELD);
            this.put("GameSessionName", GAME_SESSION_NAME_FIELD);
            this.put("GameSessionId", GAME_SESSION_ID_FIELD);
            this.put("GameSessionArn", GAME_SESSION_ARN_FIELD);
            this.put("GameSessionRegion", GAME_SESSION_REGION_FIELD);
            this.put("PlayerLatencies", PLAYER_LATENCIES_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("IpAddress", IP_ADDRESS_FIELD);
            this.put("DnsName", DNS_NAME_FIELD);
            this.put("Port", PORT_FIELD);
            this.put("PlacedPlayerSessions", PLACED_PLAYER_SESSIONS_FIELD);
            this.put("GameSessionData", GAME_SESSION_DATA_FIELD);
            this.put("MatchmakerData", MATCHMAKER_DATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String placementId;
    private final String gameSessionQueueName;
    private final String status;
    private final List<GameProperty> gameProperties;
    private final Integer maximumPlayerSessionCount;
    private final String gameSessionName;
    private final String gameSessionId;
    private final String gameSessionArn;
    private final String gameSessionRegion;
    private final List<PlayerLatency> playerLatencies;
    private final Instant startTime;
    private final Instant endTime;
    private final String ipAddress;
    private final String dnsName;
    private final Integer port;
    private final List<PlacedPlayerSession> placedPlayerSessions;
    private final String gameSessionData;
    private final String matchmakerData;

    private GameSessionPlacement(BuilderImpl builder) {
        this.placementId = builder.placementId;
        this.gameSessionQueueName = builder.gameSessionQueueName;
        this.status = builder.status;
        this.gameProperties = builder.gameProperties;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.gameSessionName = builder.gameSessionName;
        this.gameSessionId = builder.gameSessionId;
        this.gameSessionArn = builder.gameSessionArn;
        this.gameSessionRegion = builder.gameSessionRegion;
        this.playerLatencies = builder.playerLatencies;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.ipAddress = builder.ipAddress;
        this.dnsName = builder.dnsName;
        this.port = builder.port;
        this.placedPlayerSessions = builder.placedPlayerSessions;
        this.gameSessionData = builder.gameSessionData;
        this.matchmakerData = builder.matchmakerData;
    }

    public final String placementId() {
        return this.placementId;
    }

    public final String gameSessionQueueName() {
        return this.gameSessionQueueName;
    }

    public final GameSessionPlacementState status() {
        return GameSessionPlacementState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasGameProperties() {
        return this.gameProperties != null && !(this.gameProperties instanceof SdkAutoConstructList);
    }

    public final List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public final Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public final String gameSessionName() {
        return this.gameSessionName;
    }

    public final String gameSessionId() {
        return this.gameSessionId;
    }

    public final String gameSessionArn() {
        return this.gameSessionArn;
    }

    public final String gameSessionRegion() {
        return this.gameSessionRegion;
    }

    public final boolean hasPlayerLatencies() {
        return this.playerLatencies != null && !(this.playerLatencies instanceof SdkAutoConstructList);
    }

    public final List<PlayerLatency> playerLatencies() {
        return this.playerLatencies;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final Integer port() {
        return this.port;
    }

    public final boolean hasPlacedPlayerSessions() {
        return this.placedPlayerSessions != null && !(this.placedPlayerSessions instanceof SdkAutoConstructList);
    }

    public final List<PlacedPlayerSession> placedPlayerSessions() {
        return this.placedPlayerSessions;
    }

    public final String gameSessionData() {
        return this.gameSessionData;
    }

    public final String matchmakerData() {
        return this.matchmakerData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.placementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameProperties() ? this.gameProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlayerLatencies() ? this.playerLatencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacedPlayerSessions() ? this.placedPlayerSessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionData());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchmakerData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionPlacement)) {
            return false;
        }
        GameSessionPlacement other = (GameSessionPlacement)obj;
        return Objects.equals(this.placementId(), other.placementId()) && Objects.equals(this.gameSessionQueueName(), other.gameSessionQueueName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasGameProperties() == other.hasGameProperties() && Objects.equals(this.gameProperties(), other.gameProperties()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount()) && Objects.equals(this.gameSessionName(), other.gameSessionName()) && Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.gameSessionArn(), other.gameSessionArn()) && Objects.equals(this.gameSessionRegion(), other.gameSessionRegion()) && this.hasPlayerLatencies() == other.hasPlayerLatencies() && Objects.equals(this.playerLatencies(), other.playerLatencies()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.port(), other.port()) && this.hasPlacedPlayerSessions() == other.hasPlacedPlayerSessions() && Objects.equals(this.placedPlayerSessions(), other.placedPlayerSessions()) && Objects.equals(this.gameSessionData(), other.gameSessionData()) && Objects.equals(this.matchmakerData(), other.matchmakerData());
    }

    public final String toString() {
        return ToString.builder((String)"GameSessionPlacement").add("PlacementId", (Object)this.placementId()).add("GameSessionQueueName", (Object)this.gameSessionQueueName()).add("Status", (Object)this.statusAsString()).add("GameProperties", this.hasGameProperties() ? this.gameProperties() : null).add("MaximumPlayerSessionCount", (Object)this.maximumPlayerSessionCount()).add("GameSessionName", (Object)this.gameSessionName()).add("GameSessionId", (Object)this.gameSessionId()).add("GameSessionArn", (Object)this.gameSessionArn()).add("GameSessionRegion", (Object)this.gameSessionRegion()).add("PlayerLatencies", this.hasPlayerLatencies() ? this.playerLatencies() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("IpAddress", (Object)(this.ipAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("DnsName", (Object)this.dnsName()).add("Port", (Object)(this.port() == null ? null : "*** Sensitive Data Redacted ***")).add("PlacedPlayerSessions", this.hasPlacedPlayerSessions() ? this.placedPlayerSessions() : null).add("GameSessionData", (Object)this.gameSessionData()).add("MatchmakerData", (Object)this.matchmakerData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlacementId": {
                return Optional.ofNullable(clazz.cast(this.placementId()));
            }
            case "GameSessionQueueName": {
                return Optional.ofNullable(clazz.cast(this.gameSessionQueueName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "GameProperties": {
                return Optional.ofNullable(clazz.cast(this.gameProperties()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.ofNullable(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "GameSessionName": {
                return Optional.ofNullable(clazz.cast(this.gameSessionName()));
            }
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "GameSessionArn": {
                return Optional.ofNullable(clazz.cast(this.gameSessionArn()));
            }
            case "GameSessionRegion": {
                return Optional.ofNullable(clazz.cast(this.gameSessionRegion()));
            }
            case "PlayerLatencies": {
                return Optional.ofNullable(clazz.cast(this.playerLatencies()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "PlacedPlayerSessions": {
                return Optional.ofNullable(clazz.cast(this.placedPlayerSessions()));
            }
            case "GameSessionData": {
                return Optional.ofNullable(clazz.cast(this.gameSessionData()));
            }
            case "MatchmakerData": {
                return Optional.ofNullable(clazz.cast(this.matchmakerData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GameSessionPlacement, T> g) {
        return obj -> g.apply((GameSessionPlacement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String placementId;
        private String gameSessionQueueName;
        private String status;
        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();
        private Integer maximumPlayerSessionCount;
        private String gameSessionName;
        private String gameSessionId;
        private String gameSessionArn;
        private String gameSessionRegion;
        private List<PlayerLatency> playerLatencies = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private String ipAddress;
        private String dnsName;
        private Integer port;
        private List<PlacedPlayerSession> placedPlayerSessions = DefaultSdkAutoConstructList.getInstance();
        private String gameSessionData;
        private String matchmakerData;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionPlacement model) {
            this.placementId(model.placementId);
            this.gameSessionQueueName(model.gameSessionQueueName);
            this.status(model.status);
            this.gameProperties(model.gameProperties);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.gameSessionName(model.gameSessionName);
            this.gameSessionId(model.gameSessionId);
            this.gameSessionArn(model.gameSessionArn);
            this.gameSessionRegion(model.gameSessionRegion);
            this.playerLatencies(model.playerLatencies);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.ipAddress(model.ipAddress);
            this.dnsName(model.dnsName);
            this.port(model.port);
            this.placedPlayerSessions(model.placedPlayerSessions);
            this.gameSessionData(model.gameSessionData);
            this.matchmakerData(model.matchmakerData);
        }

        public final String getPlacementId() {
            return this.placementId;
        }

        public final void setPlacementId(String placementId) {
            this.placementId = placementId;
        }

        @Override
        public final Builder placementId(String placementId) {
            this.placementId = placementId;
            return this;
        }

        public final String getGameSessionQueueName() {
            return this.gameSessionQueueName;
        }

        public final void setGameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
        }

        @Override
        public final Builder gameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GameSessionPlacementState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<GameProperty.Builder> getGameProperties() {
            List<GameProperty.Builder> result = GamePropertyListCopier.copyToBuilder(this.gameProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder> ... gameProperties) {
            this.gameProperties(Stream.of(gameProperties).map(c -> (GameProperty)((GameProperty.Builder)GameProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final String getGameSessionName() {
            return this.gameSessionName;
        }

        public final void setGameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
        }

        @Override
        public final Builder gameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
            return this;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getGameSessionArn() {
            return this.gameSessionArn;
        }

        public final void setGameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
        }

        @Override
        public final Builder gameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
            return this;
        }

        public final String getGameSessionRegion() {
            return this.gameSessionRegion;
        }

        public final void setGameSessionRegion(String gameSessionRegion) {
            this.gameSessionRegion = gameSessionRegion;
        }

        @Override
        public final Builder gameSessionRegion(String gameSessionRegion) {
            this.gameSessionRegion = gameSessionRegion;
            return this;
        }

        public final List<PlayerLatency.Builder> getPlayerLatencies() {
            List<PlayerLatency.Builder> result = PlayerLatencyListCopier.copyToBuilder(this.playerLatencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlayerLatencies(Collection<PlayerLatency.BuilderImpl> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copyFromBuilder(playerLatencies);
        }

        @Override
        public final Builder playerLatencies(Collection<PlayerLatency> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copy(playerLatencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencies(PlayerLatency ... playerLatencies) {
            this.playerLatencies(Arrays.asList(playerLatencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencies(Consumer<PlayerLatency.Builder> ... playerLatencies) {
            this.playerLatencies(Stream.of(playerLatencies).map(c -> (PlayerLatency)((PlayerLatency.Builder)PlayerLatency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final List<PlacedPlayerSession.Builder> getPlacedPlayerSessions() {
            List<PlacedPlayerSession.Builder> result = PlacedPlayerSessionListCopier.copyToBuilder(this.placedPlayerSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacedPlayerSessions(Collection<PlacedPlayerSession.BuilderImpl> placedPlayerSessions) {
            this.placedPlayerSessions = PlacedPlayerSessionListCopier.copyFromBuilder(placedPlayerSessions);
        }

        @Override
        public final Builder placedPlayerSessions(Collection<PlacedPlayerSession> placedPlayerSessions) {
            this.placedPlayerSessions = PlacedPlayerSessionListCopier.copy(placedPlayerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placedPlayerSessions(PlacedPlayerSession ... placedPlayerSessions) {
            this.placedPlayerSessions(Arrays.asList(placedPlayerSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placedPlayerSessions(Consumer<PlacedPlayerSession.Builder> ... placedPlayerSessions) {
            this.placedPlayerSessions(Stream.of(placedPlayerSessions).map(c -> (PlacedPlayerSession)((PlacedPlayerSession.Builder)PlacedPlayerSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGameSessionData() {
            return this.gameSessionData;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final String getMatchmakerData() {
            return this.matchmakerData;
        }

        public final void setMatchmakerData(String matchmakerData) {
            this.matchmakerData = matchmakerData;
        }

        @Override
        public final Builder matchmakerData(String matchmakerData) {
            this.matchmakerData = matchmakerData;
            return this;
        }

        public GameSessionPlacement build() {
            return new GameSessionPlacement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GameSessionPlacement> {
        public Builder placementId(String var1);

        public Builder gameSessionQueueName(String var1);

        public Builder status(String var1);

        public Builder status(GameSessionPlacementState var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder gameProperties(Consumer<GameProperty.Builder> ... var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder gameSessionName(String var1);

        public Builder gameSessionId(String var1);

        public Builder gameSessionArn(String var1);

        public Builder gameSessionRegion(String var1);

        public Builder playerLatencies(Collection<PlayerLatency> var1);

        public Builder playerLatencies(PlayerLatency ... var1);

        public Builder playerLatencies(Consumer<PlayerLatency.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder ipAddress(String var1);

        public Builder dnsName(String var1);

        public Builder port(Integer var1);

        public Builder placedPlayerSessions(Collection<PlacedPlayerSession> var1);

        public Builder placedPlayerSessions(PlacedPlayerSession ... var1);

        public Builder placedPlayerSessions(Consumer<PlacedPlayerSession.Builder> ... var1);

        public Builder gameSessionData(String var1);

        public Builder matchmakerData(String var1);
    }
}

