/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.DeploymentImpairmentStrategy;
import software.amazon.awssdk.services.gamelift.model.DeploymentProtectionStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentConfiguration> {
    private static final SdkField<String> PROTECTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectionStrategy").getter(DeploymentConfiguration.getter(DeploymentConfiguration::protectionStrategyAsString)).setter(DeploymentConfiguration.setter(Builder::protectionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionStrategy").build()}).build();
    private static final SdkField<Integer> MINIMUM_HEALTHY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumHealthyPercentage").getter(DeploymentConfiguration.getter(DeploymentConfiguration::minimumHealthyPercentage)).setter(DeploymentConfiguration.setter(Builder::minimumHealthyPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumHealthyPercentage").build()}).build();
    private static final SdkField<String> IMPAIRMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImpairmentStrategy").getter(DeploymentConfiguration.getter(DeploymentConfiguration::impairmentStrategyAsString)).setter(DeploymentConfiguration.setter(Builder::impairmentStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpairmentStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_STRATEGY_FIELD, MINIMUM_HEALTHY_PERCENTAGE_FIELD, IMPAIRMENT_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProtectionStrategy", PROTECTION_STRATEGY_FIELD);
            this.put("MinimumHealthyPercentage", MINIMUM_HEALTHY_PERCENTAGE_FIELD);
            this.put("ImpairmentStrategy", IMPAIRMENT_STRATEGY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String protectionStrategy;
    private final Integer minimumHealthyPercentage;
    private final String impairmentStrategy;

    private DeploymentConfiguration(BuilderImpl builder) {
        this.protectionStrategy = builder.protectionStrategy;
        this.minimumHealthyPercentage = builder.minimumHealthyPercentage;
        this.impairmentStrategy = builder.impairmentStrategy;
    }

    public final DeploymentProtectionStrategy protectionStrategy() {
        return DeploymentProtectionStrategy.fromValue(this.protectionStrategy);
    }

    public final String protectionStrategyAsString() {
        return this.protectionStrategy;
    }

    public final Integer minimumHealthyPercentage() {
        return this.minimumHealthyPercentage;
    }

    public final DeploymentImpairmentStrategy impairmentStrategy() {
        return DeploymentImpairmentStrategy.fromValue(this.impairmentStrategy);
    }

    public final String impairmentStrategyAsString() {
        return this.impairmentStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumHealthyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.impairmentStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfiguration)) {
            return false;
        }
        DeploymentConfiguration other = (DeploymentConfiguration)obj;
        return Objects.equals(this.protectionStrategyAsString(), other.protectionStrategyAsString()) && Objects.equals(this.minimumHealthyPercentage(), other.minimumHealthyPercentage()) && Objects.equals(this.impairmentStrategyAsString(), other.impairmentStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentConfiguration").add("ProtectionStrategy", (Object)this.protectionStrategyAsString()).add("MinimumHealthyPercentage", (Object)this.minimumHealthyPercentage()).add("ImpairmentStrategy", (Object)this.impairmentStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectionStrategy": {
                return Optional.ofNullable(clazz.cast(this.protectionStrategyAsString()));
            }
            case "MinimumHealthyPercentage": {
                return Optional.ofNullable(clazz.cast(this.minimumHealthyPercentage()));
            }
            case "ImpairmentStrategy": {
                return Optional.ofNullable(clazz.cast(this.impairmentStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfiguration, T> g) {
        return obj -> g.apply((DeploymentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protectionStrategy;
        private Integer minimumHealthyPercentage;
        private String impairmentStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfiguration model) {
            this.protectionStrategy(model.protectionStrategy);
            this.minimumHealthyPercentage(model.minimumHealthyPercentage);
            this.impairmentStrategy(model.impairmentStrategy);
        }

        public final String getProtectionStrategy() {
            return this.protectionStrategy;
        }

        public final void setProtectionStrategy(String protectionStrategy) {
            this.protectionStrategy = protectionStrategy;
        }

        @Override
        public final Builder protectionStrategy(String protectionStrategy) {
            this.protectionStrategy = protectionStrategy;
            return this;
        }

        @Override
        public final Builder protectionStrategy(DeploymentProtectionStrategy protectionStrategy) {
            this.protectionStrategy(protectionStrategy == null ? null : protectionStrategy.toString());
            return this;
        }

        public final Integer getMinimumHealthyPercentage() {
            return this.minimumHealthyPercentage;
        }

        public final void setMinimumHealthyPercentage(Integer minimumHealthyPercentage) {
            this.minimumHealthyPercentage = minimumHealthyPercentage;
        }

        @Override
        public final Builder minimumHealthyPercentage(Integer minimumHealthyPercentage) {
            this.minimumHealthyPercentage = minimumHealthyPercentage;
            return this;
        }

        public final String getImpairmentStrategy() {
            return this.impairmentStrategy;
        }

        public final void setImpairmentStrategy(String impairmentStrategy) {
            this.impairmentStrategy = impairmentStrategy;
        }

        @Override
        public final Builder impairmentStrategy(String impairmentStrategy) {
            this.impairmentStrategy = impairmentStrategy;
            return this;
        }

        @Override
        public final Builder impairmentStrategy(DeploymentImpairmentStrategy impairmentStrategy) {
            this.impairmentStrategy(impairmentStrategy == null ? null : impairmentStrategy.toString());
            return this;
        }

        public DeploymentConfiguration build() {
            return new DeploymentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentConfiguration> {
        public Builder protectionStrategy(String var1);

        public Builder protectionStrategy(DeploymentProtectionStrategy var1);

        public Builder minimumHealthyPercentage(Integer var1);

        public Builder impairmentStrategy(String var1);

        public Builder impairmentStrategy(DeploymentImpairmentStrategy var1);
    }
}

