/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FilterInstanceStatus;
import software.amazon.awssdk.services.gamelift.model.FilterInstanceStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClaimFilterOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClaimFilterOption> {
    private static final SdkField<List<String>> INSTANCE_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceStatuses").getter(ClaimFilterOption.getter(ClaimFilterOption::instanceStatusesAsStrings)).setter(ClaimFilterOption.setter(Builder::instanceStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceStatuses", INSTANCE_STATUSES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> instanceStatuses;

    private ClaimFilterOption(BuilderImpl builder) {
        this.instanceStatuses = builder.instanceStatuses;
    }

    public final List<FilterInstanceStatus> instanceStatuses() {
        return FilterInstanceStatusesCopier.copyStringToEnum(this.instanceStatuses);
    }

    public final boolean hasInstanceStatuses() {
        return this.instanceStatuses != null && !(this.instanceStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> instanceStatusesAsStrings() {
        return this.instanceStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceStatuses() ? this.instanceStatusesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClaimFilterOption)) {
            return false;
        }
        ClaimFilterOption other = (ClaimFilterOption)obj;
        return this.hasInstanceStatuses() == other.hasInstanceStatuses() && Objects.equals(this.instanceStatusesAsStrings(), other.instanceStatusesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ClaimFilterOption").add("InstanceStatuses", this.hasInstanceStatuses() ? this.instanceStatusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceStatuses": {
                return Optional.ofNullable(clazz.cast(this.instanceStatusesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClaimFilterOption, T> g) {
        return obj -> g.apply((ClaimFilterOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instanceStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClaimFilterOption model) {
            this.instanceStatusesWithStrings(model.instanceStatuses);
        }

        public final Collection<String> getInstanceStatuses() {
            if (this.instanceStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceStatuses;
        }

        public final void setInstanceStatuses(Collection<String> instanceStatuses) {
            this.instanceStatuses = FilterInstanceStatusesCopier.copy(instanceStatuses);
        }

        @Override
        public final Builder instanceStatusesWithStrings(Collection<String> instanceStatuses) {
            this.instanceStatuses = FilterInstanceStatusesCopier.copy(instanceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatusesWithStrings(String ... instanceStatuses) {
            this.instanceStatusesWithStrings(Arrays.asList(instanceStatuses));
            return this;
        }

        @Override
        public final Builder instanceStatuses(Collection<FilterInstanceStatus> instanceStatuses) {
            this.instanceStatuses = FilterInstanceStatusesCopier.copyEnumToString(instanceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatuses(FilterInstanceStatus ... instanceStatuses) {
            this.instanceStatuses(Arrays.asList(instanceStatuses));
            return this;
        }

        public ClaimFilterOption build() {
            return new ClaimFilterOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClaimFilterOption> {
        public Builder instanceStatusesWithStrings(Collection<String> var1);

        public Builder instanceStatusesWithStrings(String ... var1);

        public Builder instanceStatuses(Collection<FilterInstanceStatus> var1);

        public Builder instanceStatuses(FilterInstanceStatus ... var1);
    }
}

