/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.MatchmakingRuleSet;
import software.amazon.awssdk.services.gamelift.model.MatchmakingRuleSetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMatchmakingRuleSetsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeMatchmakingRuleSetsResponse> {
    private static final SdkField<List<MatchmakingRuleSet>> RULE_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleSets").getter(DescribeMatchmakingRuleSetsResponse.getter(DescribeMatchmakingRuleSetsResponse::ruleSets)).setter(DescribeMatchmakingRuleSetsResponse.setter(Builder::ruleSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatchmakingRuleSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMatchmakingRuleSetsResponse.getter(DescribeMatchmakingRuleSetsResponse::nextToken)).setter(DescribeMatchmakingRuleSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RuleSets", RULE_SETS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<MatchmakingRuleSet> ruleSets;
    private final String nextToken;

    private DescribeMatchmakingRuleSetsResponse(BuilderImpl builder) {
        super(builder);
        this.ruleSets = builder.ruleSets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRuleSets() {
        return this.ruleSets != null && !(this.ruleSets instanceof SdkAutoConstructList);
    }

    public final List<MatchmakingRuleSet> ruleSets() {
        return this.ruleSets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleSets() ? this.ruleSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingRuleSetsResponse)) {
            return false;
        }
        DescribeMatchmakingRuleSetsResponse other = (DescribeMatchmakingRuleSetsResponse)((Object)obj);
        return this.hasRuleSets() == other.hasRuleSets() && Objects.equals(this.ruleSets(), other.ruleSets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMatchmakingRuleSetsResponse").add("RuleSets", this.hasRuleSets() ? this.ruleSets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSets": {
                return Optional.ofNullable(clazz.cast(this.ruleSets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMatchmakingRuleSetsResponse, T> g) {
        return obj -> g.apply((DescribeMatchmakingRuleSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<MatchmakingRuleSet> ruleSets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingRuleSetsResponse model) {
            super(model);
            this.ruleSets(model.ruleSets);
            this.nextToken(model.nextToken);
        }

        public final List<MatchmakingRuleSet.Builder> getRuleSets() {
            List<MatchmakingRuleSet.Builder> result = MatchmakingRuleSetListCopier.copyToBuilder(this.ruleSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleSets(Collection<MatchmakingRuleSet.BuilderImpl> ruleSets) {
            this.ruleSets = MatchmakingRuleSetListCopier.copyFromBuilder(ruleSets);
        }

        @Override
        public final Builder ruleSets(Collection<MatchmakingRuleSet> ruleSets) {
            this.ruleSets = MatchmakingRuleSetListCopier.copy(ruleSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(MatchmakingRuleSet ... ruleSets) {
            this.ruleSets(Arrays.asList(ruleSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(Consumer<MatchmakingRuleSet.Builder> ... ruleSets) {
            this.ruleSets(Stream.of(ruleSets).map(c -> (MatchmakingRuleSet)((MatchmakingRuleSet.Builder)MatchmakingRuleSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMatchmakingRuleSetsResponse build() {
            return new DescribeMatchmakingRuleSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMatchmakingRuleSetsResponse> {
        public Builder ruleSets(Collection<MatchmakingRuleSet> var1);

        public Builder ruleSets(MatchmakingRuleSet ... var1);

        public Builder ruleSets(Consumer<MatchmakingRuleSet.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

