/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocationModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocationModel> {
    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationName").getter(LocationModel.getter(LocationModel::locationName)).setter(LocationModel.setter(Builder::locationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationName").build()}).build();
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(LocationModel.getter(LocationModel::locationArn)).setter(LocationModel.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_NAME_FIELD, LOCATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LocationName", LOCATION_NAME_FIELD);
            this.put("LocationArn", LOCATION_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String locationName;
    private final String locationArn;

    private LocationModel(BuilderImpl builder) {
        this.locationName = builder.locationName;
        this.locationArn = builder.locationArn;
    }

    public final String locationName() {
        return this.locationName;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.locationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationModel)) {
            return false;
        }
        LocationModel other = (LocationModel)obj;
        return Objects.equals(this.locationName(), other.locationName()) && Objects.equals(this.locationArn(), other.locationArn());
    }

    public final String toString() {
        return ToString.builder((String)"LocationModel").add("LocationName", (Object)this.locationName()).add("LocationArn", (Object)this.locationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationName": {
                return Optional.ofNullable(clazz.cast(this.locationName()));
            }
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LocationModel, T> g) {
        return obj -> g.apply((LocationModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String locationName;
        private String locationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationModel model) {
            this.locationName(model.locationName);
            this.locationArn(model.locationArn);
        }

        public final String getLocationName() {
            return this.locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public LocationModel build() {
            return new LocationModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocationModel> {
        public Builder locationName(String var1);

        public Builder locationArn(String var1);
    }
}

