/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.ContainerSchedulingStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerGroupDefinitionProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerGroupDefinitionProperty> {
    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchedulingStrategy").getter(ContainerGroupDefinitionProperty.getter(ContainerGroupDefinitionProperty::schedulingStrategyAsString)).setter(ContainerGroupDefinitionProperty.setter(Builder::schedulingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulingStrategy").build()}).build();
    private static final SdkField<String> CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerGroupDefinitionName").getter(ContainerGroupDefinitionProperty.getter(ContainerGroupDefinitionProperty::containerGroupDefinitionName)).setter(ContainerGroupDefinitionProperty.setter(Builder::containerGroupDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULING_STRATEGY_FIELD, CONTAINER_GROUP_DEFINITION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SchedulingStrategy", SCHEDULING_STRATEGY_FIELD);
            this.put("ContainerGroupDefinitionName", CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String schedulingStrategy;
    private final String containerGroupDefinitionName;

    private ContainerGroupDefinitionProperty(BuilderImpl builder) {
        this.schedulingStrategy = builder.schedulingStrategy;
        this.containerGroupDefinitionName = builder.containerGroupDefinitionName;
    }

    public final ContainerSchedulingStrategy schedulingStrategy() {
        return ContainerSchedulingStrategy.fromValue(this.schedulingStrategy);
    }

    public final String schedulingStrategyAsString() {
        return this.schedulingStrategy;
    }

    public final String containerGroupDefinitionName() {
        return this.containerGroupDefinitionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerGroupDefinitionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerGroupDefinitionProperty)) {
            return false;
        }
        ContainerGroupDefinitionProperty other = (ContainerGroupDefinitionProperty)obj;
        return Objects.equals(this.schedulingStrategyAsString(), other.schedulingStrategyAsString()) && Objects.equals(this.containerGroupDefinitionName(), other.containerGroupDefinitionName());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerGroupDefinitionProperty").add("SchedulingStrategy", (Object)this.schedulingStrategyAsString()).add("ContainerGroupDefinitionName", (Object)this.containerGroupDefinitionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchedulingStrategy": {
                return Optional.ofNullable(clazz.cast(this.schedulingStrategyAsString()));
            }
            case "ContainerGroupDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.containerGroupDefinitionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ContainerGroupDefinitionProperty, T> g) {
        return obj -> g.apply((ContainerGroupDefinitionProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String schedulingStrategy;
        private String containerGroupDefinitionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerGroupDefinitionProperty model) {
            this.schedulingStrategy(model.schedulingStrategy);
            this.containerGroupDefinitionName(model.containerGroupDefinitionName);
        }

        public final String getSchedulingStrategy() {
            return this.schedulingStrategy;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(ContainerSchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final String getContainerGroupDefinitionName() {
            return this.containerGroupDefinitionName;
        }

        public final void setContainerGroupDefinitionName(String containerGroupDefinitionName) {
            this.containerGroupDefinitionName = containerGroupDefinitionName;
        }

        @Override
        public final Builder containerGroupDefinitionName(String containerGroupDefinitionName) {
            this.containerGroupDefinitionName = containerGroupDefinitionName;
            return this;
        }

        public ContainerGroupDefinitionProperty build() {
            return new ContainerGroupDefinitionProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerGroupDefinitionProperty> {
        public Builder schedulingStrategy(String var1);

        public Builder schedulingStrategy(ContainerSchedulingStrategy var1);

        public Builder containerGroupDefinitionName(String var1);
    }
}

