/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ConnectionPortRange;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinitionNameOrArnLimitedListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerGroupsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerGroupsConfiguration> {
    private static final SdkField<List<String>> CONTAINER_GROUP_DEFINITION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerGroupDefinitionNames").getter(ContainerGroupsConfiguration.getter(ContainerGroupsConfiguration::containerGroupDefinitionNames)).setter(ContainerGroupsConfiguration.setter(Builder::containerGroupDefinitionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConnectionPortRange> CONNECTION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionPortRange").getter(ContainerGroupsConfiguration.getter(ContainerGroupsConfiguration::connectionPortRange)).setter(ContainerGroupsConfiguration.setter(Builder::connectionPortRange)).constructor(ConnectionPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPortRange").build()}).build();
    private static final SdkField<Integer> DESIRED_REPLICA_CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredReplicaContainerGroupsPerInstance").getter(ContainerGroupsConfiguration.getter(ContainerGroupsConfiguration::desiredReplicaContainerGroupsPerInstance)).setter(ContainerGroupsConfiguration.setter(Builder::desiredReplicaContainerGroupsPerInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredReplicaContainerGroupsPerInstance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_GROUP_DEFINITION_NAMES_FIELD, CONNECTION_PORT_RANGE_FIELD, DESIRED_REPLICA_CONTAINER_GROUPS_PER_INSTANCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> containerGroupDefinitionNames;
    private final ConnectionPortRange connectionPortRange;
    private final Integer desiredReplicaContainerGroupsPerInstance;

    private ContainerGroupsConfiguration(BuilderImpl builder) {
        this.containerGroupDefinitionNames = builder.containerGroupDefinitionNames;
        this.connectionPortRange = builder.connectionPortRange;
        this.desiredReplicaContainerGroupsPerInstance = builder.desiredReplicaContainerGroupsPerInstance;
    }

    public final boolean hasContainerGroupDefinitionNames() {
        return this.containerGroupDefinitionNames != null && !(this.containerGroupDefinitionNames instanceof SdkAutoConstructList);
    }

    public final List<String> containerGroupDefinitionNames() {
        return this.containerGroupDefinitionNames;
    }

    public final ConnectionPortRange connectionPortRange() {
        return this.connectionPortRange;
    }

    public final Integer desiredReplicaContainerGroupsPerInstance() {
        return this.desiredReplicaContainerGroupsPerInstance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerGroupDefinitionNames() ? this.containerGroupDefinitionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredReplicaContainerGroupsPerInstance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerGroupsConfiguration)) {
            return false;
        }
        ContainerGroupsConfiguration other = (ContainerGroupsConfiguration)obj;
        return this.hasContainerGroupDefinitionNames() == other.hasContainerGroupDefinitionNames() && Objects.equals(this.containerGroupDefinitionNames(), other.containerGroupDefinitionNames()) && Objects.equals(this.connectionPortRange(), other.connectionPortRange()) && Objects.equals(this.desiredReplicaContainerGroupsPerInstance(), other.desiredReplicaContainerGroupsPerInstance());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerGroupsConfiguration").add("ContainerGroupDefinitionNames", this.hasContainerGroupDefinitionNames() ? this.containerGroupDefinitionNames() : null).add("ConnectionPortRange", (Object)this.connectionPortRange()).add("DesiredReplicaContainerGroupsPerInstance", (Object)this.desiredReplicaContainerGroupsPerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerGroupDefinitionNames": {
                return Optional.ofNullable(clazz.cast(this.containerGroupDefinitionNames()));
            }
            case "ConnectionPortRange": {
                return Optional.ofNullable(clazz.cast(this.connectionPortRange()));
            }
            case "DesiredReplicaContainerGroupsPerInstance": {
                return Optional.ofNullable(clazz.cast(this.desiredReplicaContainerGroupsPerInstance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerGroupsConfiguration, T> g) {
        return obj -> g.apply((ContainerGroupsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> containerGroupDefinitionNames = DefaultSdkAutoConstructList.getInstance();
        private ConnectionPortRange connectionPortRange;
        private Integer desiredReplicaContainerGroupsPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerGroupsConfiguration model) {
            this.containerGroupDefinitionNames(model.containerGroupDefinitionNames);
            this.connectionPortRange(model.connectionPortRange);
            this.desiredReplicaContainerGroupsPerInstance(model.desiredReplicaContainerGroupsPerInstance);
        }

        public final Collection<String> getContainerGroupDefinitionNames() {
            if (this.containerGroupDefinitionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerGroupDefinitionNames;
        }

        public final void setContainerGroupDefinitionNames(Collection<String> containerGroupDefinitionNames) {
            this.containerGroupDefinitionNames = ContainerGroupDefinitionNameOrArnLimitedListCopier.copy(containerGroupDefinitionNames);
        }

        @Override
        public final Builder containerGroupDefinitionNames(Collection<String> containerGroupDefinitionNames) {
            this.containerGroupDefinitionNames = ContainerGroupDefinitionNameOrArnLimitedListCopier.copy(containerGroupDefinitionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerGroupDefinitionNames(String ... containerGroupDefinitionNames) {
            this.containerGroupDefinitionNames(Arrays.asList(containerGroupDefinitionNames));
            return this;
        }

        public final ConnectionPortRange.Builder getConnectionPortRange() {
            return this.connectionPortRange != null ? this.connectionPortRange.toBuilder() : null;
        }

        public final void setConnectionPortRange(ConnectionPortRange.BuilderImpl connectionPortRange) {
            this.connectionPortRange = connectionPortRange != null ? connectionPortRange.build() : null;
        }

        @Override
        public final Builder connectionPortRange(ConnectionPortRange connectionPortRange) {
            this.connectionPortRange = connectionPortRange;
            return this;
        }

        public final Integer getDesiredReplicaContainerGroupsPerInstance() {
            return this.desiredReplicaContainerGroupsPerInstance;
        }

        public final void setDesiredReplicaContainerGroupsPerInstance(Integer desiredReplicaContainerGroupsPerInstance) {
            this.desiredReplicaContainerGroupsPerInstance = desiredReplicaContainerGroupsPerInstance;
        }

        @Override
        public final Builder desiredReplicaContainerGroupsPerInstance(Integer desiredReplicaContainerGroupsPerInstance) {
            this.desiredReplicaContainerGroupsPerInstance = desiredReplicaContainerGroupsPerInstance;
            return this;
        }

        public ContainerGroupsConfiguration build() {
            return new ContainerGroupsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerGroupsConfiguration> {
        public Builder containerGroupDefinitionNames(Collection<String> var1);

        public Builder containerGroupDefinitionNames(String ... var1);

        public Builder connectionPortRange(ConnectionPortRange var1);

        default public Builder connectionPortRange(Consumer<ConnectionPortRange.Builder> connectionPortRange) {
            return this.connectionPortRange((ConnectionPortRange)((ConnectionPortRange.Builder)ConnectionPortRange.builder().applyMutation(connectionPortRange)).build());
        }

        public Builder desiredReplicaContainerGroupsPerInstance(Integer var1);
    }
}

