/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinition;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsRequest;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsResponse;

public class ListContainerGroupDefinitionsPublisher
implements SdkPublisher<ListContainerGroupDefinitionsResponse> {
    private final GameLiftAsyncClient client;
    private final ListContainerGroupDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContainerGroupDefinitionsPublisher(GameLiftAsyncClient client, ListContainerGroupDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContainerGroupDefinitionsPublisher(GameLiftAsyncClient client, ListContainerGroupDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContainerGroupDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContainerGroupDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContainerGroupDefinition> containerGroupDefinitions() {
        Function<ListContainerGroupDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.containerGroupDefinitions() != null) {
                return response.containerGroupDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContainerGroupDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContainerGroupDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListContainerGroupDefinitionsResponse> {
        private ListContainerGroupDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListContainerGroupDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContainerGroupDefinitionsResponse> nextPage(ListContainerGroupDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListContainerGroupDefinitionsPublisher.this.client.listContainerGroupDefinitions(ListContainerGroupDefinitionsPublisher.this.firstRequest);
            }
            return ListContainerGroupDefinitionsPublisher.this.client.listContainerGroupDefinitions((ListContainerGroupDefinitionsRequest)((Object)ListContainerGroupDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

