/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.LocationListCopier;
import software.amazon.awssdk.services.gamelift.model.PriorityType;
import software.amazon.awssdk.services.gamelift.model.PriorityTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PriorityConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PriorityConfiguration> {
    private static final SdkField<List<String>> PRIORITY_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PriorityOrder").getter(PriorityConfiguration.getter(PriorityConfiguration::priorityOrderAsStrings)).setter(PriorityConfiguration.setter(Builder::priorityOrderWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriorityOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOCATION_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocationOrder").getter(PriorityConfiguration.getter(PriorityConfiguration::locationOrder)).setter(PriorityConfiguration.setter(Builder::locationOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIORITY_ORDER_FIELD, LOCATION_ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> priorityOrder;
    private final List<String> locationOrder;

    private PriorityConfiguration(BuilderImpl builder) {
        this.priorityOrder = builder.priorityOrder;
        this.locationOrder = builder.locationOrder;
    }

    public final List<PriorityType> priorityOrder() {
        return PriorityTypeListCopier.copyStringToEnum(this.priorityOrder);
    }

    public final boolean hasPriorityOrder() {
        return this.priorityOrder != null && !(this.priorityOrder instanceof SdkAutoConstructList);
    }

    public final List<String> priorityOrderAsStrings() {
        return this.priorityOrder;
    }

    public final boolean hasLocationOrder() {
        return this.locationOrder != null && !(this.locationOrder instanceof SdkAutoConstructList);
    }

    public final List<String> locationOrder() {
        return this.locationOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPriorityOrder() ? this.priorityOrderAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationOrder() ? this.locationOrder() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriorityConfiguration)) {
            return false;
        }
        PriorityConfiguration other = (PriorityConfiguration)obj;
        return this.hasPriorityOrder() == other.hasPriorityOrder() && Objects.equals(this.priorityOrderAsStrings(), other.priorityOrderAsStrings()) && this.hasLocationOrder() == other.hasLocationOrder() && Objects.equals(this.locationOrder(), other.locationOrder());
    }

    public final String toString() {
        return ToString.builder((String)"PriorityConfiguration").add("PriorityOrder", this.hasPriorityOrder() ? this.priorityOrderAsStrings() : null).add("LocationOrder", this.hasLocationOrder() ? this.locationOrder() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PriorityOrder": {
                return Optional.ofNullable(clazz.cast(this.priorityOrderAsStrings()));
            }
            case "LocationOrder": {
                return Optional.ofNullable(clazz.cast(this.locationOrder()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PriorityConfiguration, T> g) {
        return obj -> g.apply((PriorityConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> priorityOrder = DefaultSdkAutoConstructList.getInstance();
        private List<String> locationOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PriorityConfiguration model) {
            this.priorityOrderWithStrings(model.priorityOrder);
            this.locationOrder(model.locationOrder);
        }

        public final Collection<String> getPriorityOrder() {
            if (this.priorityOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return this.priorityOrder;
        }

        public final void setPriorityOrder(Collection<String> priorityOrder) {
            this.priorityOrder = PriorityTypeListCopier.copy(priorityOrder);
        }

        @Override
        public final Builder priorityOrderWithStrings(Collection<String> priorityOrder) {
            this.priorityOrder = PriorityTypeListCopier.copy(priorityOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priorityOrderWithStrings(String ... priorityOrder) {
            this.priorityOrderWithStrings(Arrays.asList(priorityOrder));
            return this;
        }

        @Override
        public final Builder priorityOrder(Collection<PriorityType> priorityOrder) {
            this.priorityOrder = PriorityTypeListCopier.copyEnumToString(priorityOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priorityOrder(PriorityType ... priorityOrder) {
            this.priorityOrder(Arrays.asList(priorityOrder));
            return this;
        }

        public final Collection<String> getLocationOrder() {
            if (this.locationOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return this.locationOrder;
        }

        public final void setLocationOrder(Collection<String> locationOrder) {
            this.locationOrder = LocationListCopier.copy(locationOrder);
        }

        @Override
        public final Builder locationOrder(Collection<String> locationOrder) {
            this.locationOrder = LocationListCopier.copy(locationOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationOrder(String ... locationOrder) {
            this.locationOrder(Arrays.asList(locationOrder));
            return this;
        }

        public PriorityConfiguration build() {
            return new PriorityConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PriorityConfiguration> {
        public Builder priorityOrderWithStrings(Collection<String> var1);

        public Builder priorityOrderWithStrings(String ... var1);

        public Builder priorityOrder(Collection<PriorityType> var1);

        public Builder priorityOrder(PriorityType ... var1);

        public Builder locationOrder(Collection<String> var1);

        public Builder locationOrder(String ... var1);
    }
}

