/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.Compute;
import software.amazon.awssdk.services.gamelift.model.ComputeListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComputeResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, ListComputeResponse> {
    private static final SdkField<List<Compute>> COMPUTE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComputeList").getter(ListComputeResponse.getter(ListComputeResponse::computeList)).setter(ListComputeResponse.setter(Builder::computeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Compute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListComputeResponse.getter(ListComputeResponse::nextToken)).setter(ListComputeResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<Compute> computeList;
    private final String nextToken;

    private ListComputeResponse(BuilderImpl builder) {
        super(builder);
        this.computeList = builder.computeList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComputeList() {
        return this.computeList != null && !(this.computeList instanceof SdkAutoConstructList);
    }

    public final List<Compute> computeList() {
        return this.computeList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeList() ? this.computeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComputeResponse)) {
            return false;
        }
        ListComputeResponse other = (ListComputeResponse)((Object)obj);
        return this.hasComputeList() == other.hasComputeList() && Objects.equals(this.computeList(), other.computeList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListComputeResponse").add("ComputeList", this.hasComputeList() ? this.computeList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputeList": {
                return Optional.ofNullable(clazz.cast(this.computeList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComputeResponse, T> g) {
        return obj -> g.apply((ListComputeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<Compute> computeList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComputeResponse model) {
            super(model);
            this.computeList(model.computeList);
            this.nextToken(model.nextToken);
        }

        public final List<Compute.Builder> getComputeList() {
            List<Compute.Builder> result = ComputeListCopier.copyToBuilder(this.computeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeList(Collection<Compute.BuilderImpl> computeList) {
            this.computeList = ComputeListCopier.copyFromBuilder(computeList);
        }

        @Override
        public final Builder computeList(Collection<Compute> computeList) {
            this.computeList = ComputeListCopier.copy(computeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeList(Compute ... computeList) {
            this.computeList(Arrays.asList(computeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeList(Consumer<Compute.Builder> ... computeList) {
            this.computeList(Stream.of(computeList).map(c -> (Compute)((Compute.Builder)Compute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComputeResponse build() {
            return new ListComputeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComputeResponse> {
        public Builder computeList(Collection<Compute> var1);

        public Builder computeList(Compute ... var1);

        public Builder computeList(Consumer<Compute.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

