/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.LocationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFleetLocationsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DeleteFleetLocationsRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(DeleteFleetLocationsRequest.getter(DeleteFleetLocationsRequest::fleetId)).setter(DeleteFleetLocationsRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<List<String>> LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Locations").getter(DeleteFleetLocationsRequest.getter(DeleteFleetLocationsRequest::locations)).setter(DeleteFleetLocationsRequest.setter(Builder::locations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, LOCATIONS_FIELD));
    private final String fleetId;
    private final List<String> locations;

    private DeleteFleetLocationsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.locations = builder.locations;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final boolean hasLocations() {
        return this.locations != null && !(this.locations instanceof SdkAutoConstructList);
    }

    public final List<String> locations() {
        return this.locations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocations() ? this.locations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetLocationsRequest)) {
            return false;
        }
        DeleteFleetLocationsRequest other = (DeleteFleetLocationsRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && this.hasLocations() == other.hasLocations() && Objects.equals(this.locations(), other.locations());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFleetLocationsRequest").add("FleetId", (Object)this.fleetId()).add("Locations", this.hasLocations() ? this.locations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "Locations": {
                return Optional.ofNullable(clazz.cast(this.locations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFleetLocationsRequest, T> g) {
        return obj -> g.apply((DeleteFleetLocationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private List<String> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetLocationsRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.locations(model.locations);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final Collection<String> getLocations() {
            if (this.locations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.locations;
        }

        public final void setLocations(Collection<String> locations) {
            this.locations = LocationListCopier.copy(locations);
        }

        @Override
        public final Builder locations(Collection<String> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(String ... locations) {
            this.locations(Arrays.asList(locations));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFleetLocationsRequest build() {
            return new DeleteFleetLocationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFleetLocationsRequest> {
        public Builder fleetId(String var1);

        public Builder locations(Collection<String> var1);

        public Builder locations(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

