/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ContainerCommandStringListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerDependency;
import software.amazon.awssdk.services.gamelift.model.ContainerDependencyListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerEntryPointListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerEnvironment;
import software.amazon.awssdk.services.gamelift.model.ContainerEnvironmentListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerHealthCheck;
import software.amazon.awssdk.services.gamelift.model.ContainerMemoryLimits;
import software.amazon.awssdk.services.gamelift.model.ContainerPortConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerDefinitionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerDefinitionInput> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerName").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::containerName)).setter(ContainerDefinitionInput.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()}).build();
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUri").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::imageUri)).setter(ContainerDefinitionInput.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()}).build();
    private static final SdkField<ContainerMemoryLimits> MEMORY_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemoryLimits").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::memoryLimits)).setter(ContainerDefinitionInput.setter(Builder::memoryLimits)).constructor(ContainerMemoryLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryLimits").build()}).build();
    private static final SdkField<ContainerPortConfiguration> PORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PortConfiguration").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::portConfiguration)).setter(ContainerDefinitionInput.setter(Builder::portConfiguration)).constructor(ContainerPortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortConfiguration").build()}).build();
    private static final SdkField<Integer> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Cpu").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::cpu)).setter(ContainerDefinitionInput.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cpu").build()}).build();
    private static final SdkField<ContainerHealthCheck> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheck").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::healthCheck)).setter(ContainerDefinitionInput.setter(Builder::healthCheck)).constructor(ContainerHealthCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()}).build();
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Command").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::command)).setter(ContainerDefinitionInput.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ESSENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Essential").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::essential)).setter(ContainerDefinitionInput.setter(Builder::essential)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Essential").build()}).build();
    private static final SdkField<List<String>> ENTRY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntryPoint").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::entryPoint)).setter(ContainerDefinitionInput.setter(Builder::entryPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryPoint").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkingDirectory").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::workingDirectory)).setter(ContainerDefinitionInput.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()}).build();
    private static final SdkField<List<ContainerEnvironment>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Environment").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::environment)).setter(ContainerDefinitionInput.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContainerDependency>> DEPENDS_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DependsOn").getter(ContainerDefinitionInput.getter(ContainerDefinitionInput::dependsOn)).setter(ContainerDefinitionInput.setter(Builder::dependsOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependsOn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, IMAGE_URI_FIELD, MEMORY_LIMITS_FIELD, PORT_CONFIGURATION_FIELD, CPU_FIELD, HEALTH_CHECK_FIELD, COMMAND_FIELD, ESSENTIAL_FIELD, ENTRY_POINT_FIELD, WORKING_DIRECTORY_FIELD, ENVIRONMENT_FIELD, DEPENDS_ON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerName;
    private final String imageUri;
    private final ContainerMemoryLimits memoryLimits;
    private final ContainerPortConfiguration portConfiguration;
    private final Integer cpu;
    private final ContainerHealthCheck healthCheck;
    private final List<String> command;
    private final Boolean essential;
    private final List<String> entryPoint;
    private final String workingDirectory;
    private final List<ContainerEnvironment> environment;
    private final List<ContainerDependency> dependsOn;

    private ContainerDefinitionInput(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.imageUri = builder.imageUri;
        this.memoryLimits = builder.memoryLimits;
        this.portConfiguration = builder.portConfiguration;
        this.cpu = builder.cpu;
        this.healthCheck = builder.healthCheck;
        this.command = builder.command;
        this.essential = builder.essential;
        this.entryPoint = builder.entryPoint;
        this.workingDirectory = builder.workingDirectory;
        this.environment = builder.environment;
        this.dependsOn = builder.dependsOn;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final String imageUri() {
        return this.imageUri;
    }

    public final ContainerMemoryLimits memoryLimits() {
        return this.memoryLimits;
    }

    public final ContainerPortConfiguration portConfiguration() {
        return this.portConfiguration;
    }

    public final Integer cpu() {
        return this.cpu;
    }

    public final ContainerHealthCheck healthCheck() {
        return this.healthCheck;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final Boolean essential() {
        return this.essential;
    }

    public final boolean hasEntryPoint() {
        return this.entryPoint != null && !(this.entryPoint instanceof SdkAutoConstructList);
    }

    public final List<String> entryPoint() {
        return this.entryPoint;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructList);
    }

    public final List<ContainerEnvironment> environment() {
        return this.environment;
    }

    public final boolean hasDependsOn() {
        return this.dependsOn != null && !(this.dependsOn instanceof SdkAutoConstructList);
    }

    public final List<ContainerDependency> dependsOn() {
        return this.dependsOn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.portConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.essential());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntryPoint() ? this.entryPoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependsOn() ? this.dependsOn() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinitionInput)) {
            return false;
        }
        ContainerDefinitionInput other = (ContainerDefinitionInput)obj;
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.imageUri(), other.imageUri()) && Objects.equals(this.memoryLimits(), other.memoryLimits()) && Objects.equals(this.portConfiguration(), other.portConfiguration()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.healthCheck(), other.healthCheck()) && this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && Objects.equals(this.essential(), other.essential()) && this.hasEntryPoint() == other.hasEntryPoint() && Objects.equals(this.entryPoint(), other.entryPoint()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && this.hasDependsOn() == other.hasDependsOn() && Objects.equals(this.dependsOn(), other.dependsOn());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerDefinitionInput").add("ContainerName", (Object)this.containerName()).add("ImageUri", (Object)this.imageUri()).add("MemoryLimits", (Object)this.memoryLimits()).add("PortConfiguration", (Object)this.portConfiguration()).add("Cpu", (Object)this.cpu()).add("HealthCheck", (Object)this.healthCheck()).add("Command", this.hasCommand() ? this.command() : null).add("Essential", (Object)this.essential()).add("EntryPoint", this.hasEntryPoint() ? this.entryPoint() : null).add("WorkingDirectory", (Object)this.workingDirectory()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("DependsOn", this.hasDependsOn() ? this.dependsOn() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "ImageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
            case "MemoryLimits": {
                return Optional.ofNullable(clazz.cast(this.memoryLimits()));
            }
            case "PortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.portConfiguration()));
            }
            case "Cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "HealthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "Essential": {
                return Optional.ofNullable(clazz.cast(this.essential()));
            }
            case "EntryPoint": {
                return Optional.ofNullable(clazz.cast(this.entryPoint()));
            }
            case "WorkingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "DependsOn": {
                return Optional.ofNullable(clazz.cast(this.dependsOn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDefinitionInput, T> g) {
        return obj -> g.apply((ContainerDefinitionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerName;
        private String imageUri;
        private ContainerMemoryLimits memoryLimits;
        private ContainerPortConfiguration portConfiguration;
        private Integer cpu;
        private ContainerHealthCheck healthCheck;
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private Boolean essential;
        private List<String> entryPoint = DefaultSdkAutoConstructList.getInstance();
        private String workingDirectory;
        private List<ContainerEnvironment> environment = DefaultSdkAutoConstructList.getInstance();
        private List<ContainerDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDefinitionInput model) {
            this.containerName(model.containerName);
            this.imageUri(model.imageUri);
            this.memoryLimits(model.memoryLimits);
            this.portConfiguration(model.portConfiguration);
            this.cpu(model.cpu);
            this.healthCheck(model.healthCheck);
            this.command(model.command);
            this.essential(model.essential);
            this.entryPoint(model.entryPoint);
            this.workingDirectory(model.workingDirectory);
            this.environment(model.environment);
            this.dependsOn(model.dependsOn);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final ContainerMemoryLimits.Builder getMemoryLimits() {
            return this.memoryLimits != null ? this.memoryLimits.toBuilder() : null;
        }

        public final void setMemoryLimits(ContainerMemoryLimits.BuilderImpl memoryLimits) {
            this.memoryLimits = memoryLimits != null ? memoryLimits.build() : null;
        }

        @Override
        public final Builder memoryLimits(ContainerMemoryLimits memoryLimits) {
            this.memoryLimits = memoryLimits;
            return this;
        }

        public final ContainerPortConfiguration.Builder getPortConfiguration() {
            return this.portConfiguration != null ? this.portConfiguration.toBuilder() : null;
        }

        public final void setPortConfiguration(ContainerPortConfiguration.BuilderImpl portConfiguration) {
            this.portConfiguration = portConfiguration != null ? portConfiguration.build() : null;
        }

        @Override
        public final Builder portConfiguration(ContainerPortConfiguration portConfiguration) {
            this.portConfiguration = portConfiguration;
            return this;
        }

        public final Integer getCpu() {
            return this.cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final ContainerHealthCheck.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(ContainerHealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(ContainerHealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = ContainerCommandStringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = ContainerCommandStringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final Boolean getEssential() {
            return this.essential;
        }

        public final void setEssential(Boolean essential) {
            this.essential = essential;
        }

        @Override
        public final Builder essential(Boolean essential) {
            this.essential = essential;
            return this;
        }

        public final Collection<String> getEntryPoint() {
            if (this.entryPoint instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entryPoint;
        }

        public final void setEntryPoint(Collection<String> entryPoint) {
            this.entryPoint = ContainerEntryPointListCopier.copy(entryPoint);
        }

        @Override
        public final Builder entryPoint(Collection<String> entryPoint) {
            this.entryPoint = ContainerEntryPointListCopier.copy(entryPoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryPoint(String ... entryPoint) {
            this.entryPoint(Arrays.asList(entryPoint));
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final List<ContainerEnvironment.Builder> getEnvironment() {
            List<ContainerEnvironment.Builder> result = ContainerEnvironmentListCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<ContainerEnvironment.BuilderImpl> environment) {
            this.environment = ContainerEnvironmentListCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<ContainerEnvironment> environment) {
            this.environment = ContainerEnvironmentListCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(ContainerEnvironment ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<ContainerEnvironment.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (ContainerEnvironment)((ContainerEnvironment.Builder)ContainerEnvironment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContainerDependency.Builder> getDependsOn() {
            List<ContainerDependency.Builder> result = ContainerDependencyListCopier.copyToBuilder(this.dependsOn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependsOn(Collection<ContainerDependency.BuilderImpl> dependsOn) {
            this.dependsOn = ContainerDependencyListCopier.copyFromBuilder(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<ContainerDependency> dependsOn) {
            this.dependsOn = ContainerDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(ContainerDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<ContainerDependency.Builder> ... dependsOn) {
            this.dependsOn(Stream.of(dependsOn).map(c -> (ContainerDependency)((ContainerDependency.Builder)ContainerDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContainerDefinitionInput build() {
            return new ContainerDefinitionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerDefinitionInput> {
        public Builder containerName(String var1);

        public Builder imageUri(String var1);

        public Builder memoryLimits(ContainerMemoryLimits var1);

        default public Builder memoryLimits(Consumer<ContainerMemoryLimits.Builder> memoryLimits) {
            return this.memoryLimits((ContainerMemoryLimits)((ContainerMemoryLimits.Builder)ContainerMemoryLimits.builder().applyMutation(memoryLimits)).build());
        }

        public Builder portConfiguration(ContainerPortConfiguration var1);

        default public Builder portConfiguration(Consumer<ContainerPortConfiguration.Builder> portConfiguration) {
            return this.portConfiguration((ContainerPortConfiguration)((ContainerPortConfiguration.Builder)ContainerPortConfiguration.builder().applyMutation(portConfiguration)).build());
        }

        public Builder cpu(Integer var1);

        public Builder healthCheck(ContainerHealthCheck var1);

        default public Builder healthCheck(Consumer<ContainerHealthCheck.Builder> healthCheck) {
            return this.healthCheck((ContainerHealthCheck)((ContainerHealthCheck.Builder)ContainerHealthCheck.builder().applyMutation(healthCheck)).build());
        }

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder essential(Boolean var1);

        public Builder entryPoint(Collection<String> var1);

        public Builder entryPoint(String ... var1);

        public Builder workingDirectory(String var1);

        public Builder environment(Collection<ContainerEnvironment> var1);

        public Builder environment(ContainerEnvironment ... var1);

        public Builder environment(Consumer<ContainerEnvironment.Builder> ... var1);

        public Builder dependsOn(Collection<ContainerDependency> var1);

        public Builder dependsOn(ContainerDependency ... var1);

        public Builder dependsOn(Consumer<ContainerDependency.Builder> ... var1);
    }
}

