/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.InstanceCredentials;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceAccess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceAccess> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(InstanceAccess.getter(InstanceAccess::fleetId)).setter(InstanceAccess.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceAccess.getter(InstanceAccess::instanceId)).setter(InstanceAccess.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(InstanceAccess.getter(InstanceAccess::ipAddress)).setter(InstanceAccess.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(InstanceAccess.getter(InstanceAccess::operatingSystemAsString)).setter(InstanceAccess.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<InstanceCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(InstanceAccess.getter(InstanceAccess::credentials)).setter(InstanceAccess.setter(Builder::credentials)).constructor(InstanceCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, INSTANCE_ID_FIELD, IP_ADDRESS_FIELD, OPERATING_SYSTEM_FIELD, CREDENTIALS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fleetId;
    private final String instanceId;
    private final String ipAddress;
    private final String operatingSystem;
    private final InstanceCredentials credentials;

    private InstanceAccess(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.instanceId = builder.instanceId;
        this.ipAddress = builder.ipAddress;
        this.operatingSystem = builder.operatingSystem;
        this.credentials = builder.credentials;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final InstanceCredentials credentials() {
        return this.credentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAccess)) {
            return false;
        }
        InstanceAccess other = (InstanceAccess)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.credentials(), other.credentials());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceAccess").add("FleetId", (Object)this.fleetId()).add("InstanceId", (Object)this.instanceId()).add("IpAddress", (Object)(this.ipAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceAccess, T> g) {
        return obj -> g.apply((InstanceAccess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String instanceId;
        private String ipAddress;
        private String operatingSystem;
        private InstanceCredentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAccess model) {
            this.fleetId(model.fleetId);
            this.instanceId(model.instanceId);
            this.ipAddress(model.ipAddress);
            this.operatingSystem(model.operatingSystem);
            this.credentials(model.credentials);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final InstanceCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(InstanceCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(InstanceCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public InstanceAccess build() {
            return new InstanceAccess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceAccess> {
        public Builder fleetId(String var1);

        public Builder instanceId(String var1);

        public Builder ipAddress(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder credentials(InstanceCredentials var1);

        default public Builder credentials(Consumer<InstanceCredentials.Builder> credentials) {
            return this.credentials((InstanceCredentials)((InstanceCredentials.Builder)InstanceCredentials.builder().applyMutation(credentials)).build());
        }
    }
}

