/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FlexMatchMode {
    STANDALONE("STANDALONE"),
    WITH_QUEUE("WITH_QUEUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FlexMatchMode> VALUE_MAP;
    private final String value;

    private FlexMatchMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FlexMatchMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FlexMatchMode> knownValues() {
        EnumSet<FlexMatchMode> knownValues = EnumSet.allOf(FlexMatchMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FlexMatchMode.class, FlexMatchMode::toString);
    }
}

