/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.GameServerGroup;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse;

public class ListGameServerGroupsIterable
implements SdkIterable<ListGameServerGroupsResponse> {
    private final GameLiftClient client;
    private final ListGameServerGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGameServerGroupsIterable(GameLiftClient client, ListGameServerGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGameServerGroupsResponseFetcher();
    }

    public Iterator<ListGameServerGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GameServerGroup> gameServerGroups() {
        Function<ListGameServerGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameServerGroups() != null) {
                return response.gameServerGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGameServerGroupsResponseFetcher
    implements SyncPageFetcher<ListGameServerGroupsResponse> {
        private ListGameServerGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGameServerGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGameServerGroupsResponse nextPage(ListGameServerGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGameServerGroupsIterable.this.client.listGameServerGroups(ListGameServerGroupsIterable.this.firstRequest);
            }
            return ListGameServerGroupsIterable.this.client.listGameServerGroups((ListGameServerGroupsRequest)((Object)ListGameServerGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

