/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.Compute;
import software.amazon.awssdk.services.gamelift.model.ListComputeRequest;
import software.amazon.awssdk.services.gamelift.model.ListComputeResponse;

public class ListComputeIterable
implements SdkIterable<ListComputeResponse> {
    private final GameLiftClient client;
    private final ListComputeRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComputeIterable(GameLiftClient client, ListComputeRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListComputeResponseFetcher();
    }

    public Iterator<ListComputeResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Compute> computeList() {
        Function<ListComputeResponse, Iterator> getIterator = response -> {
            if (response != null && response.computeList() != null) {
                return response.computeList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComputeResponseFetcher
    implements SyncPageFetcher<ListComputeResponse> {
        private ListComputeResponseFetcher() {
        }

        public boolean hasNextPage(ListComputeResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComputeResponse nextPage(ListComputeResponse previousPage) {
            if (previousPage == null) {
                return ListComputeIterable.this.client.listCompute(ListComputeIterable.this.firstRequest);
            }
            return ListComputeIterable.this.client.listCompute((ListComputeRequest)((Object)ListComputeIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

