/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse;

public class DescribeFleetLocationAttributesIterable
implements SdkIterable<DescribeFleetLocationAttributesResponse> {
    private final GameLiftClient client;
    private final DescribeFleetLocationAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFleetLocationAttributesIterable(GameLiftClient client, DescribeFleetLocationAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFleetLocationAttributesResponseFetcher();
    }

    public Iterator<DescribeFleetLocationAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeFleetLocationAttributesResponseFetcher
    implements SyncPageFetcher<DescribeFleetLocationAttributesResponse> {
        private DescribeFleetLocationAttributesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetLocationAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFleetLocationAttributesResponse nextPage(DescribeFleetLocationAttributesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetLocationAttributesIterable.this.client.describeFleetLocationAttributes(DescribeFleetLocationAttributesIterable.this.firstRequest);
            }
            return DescribeFleetLocationAttributesIterable.this.client.describeFleetLocationAttributes((DescribeFleetLocationAttributesRequest)((Object)DescribeFleetLocationAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

