/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.CertificateConfiguration;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.model.FleetAction;
import software.amazon.awssdk.services.gamelift.model.FleetActionListCopier;
import software.amazon.awssdk.services.gamelift.model.FleetStatus;
import software.amazon.awssdk.services.gamelift.model.FleetType;
import software.amazon.awssdk.services.gamelift.model.MetricGroupListCopier;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy;
import software.amazon.awssdk.services.gamelift.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetAttributes> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(FleetAttributes.getter(FleetAttributes::fleetId)).setter(FleetAttributes.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(FleetAttributes.getter(FleetAttributes::fleetArn)).setter(FleetAttributes.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetType").getter(FleetAttributes.getter(FleetAttributes::fleetTypeAsString)).setter(FleetAttributes.setter(Builder::fleetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(FleetAttributes.getter(FleetAttributes::instanceTypeAsString)).setter(FleetAttributes.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(FleetAttributes.getter(FleetAttributes::description)).setter(FleetAttributes.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FleetAttributes.getter(FleetAttributes::name)).setter(FleetAttributes.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(FleetAttributes.getter(FleetAttributes::creationTime)).setter(FleetAttributes.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TERMINATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TerminationTime").getter(FleetAttributes.getter(FleetAttributes::terminationTime)).setter(FleetAttributes.setter(Builder::terminationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FleetAttributes.getter(FleetAttributes::statusAsString)).setter(FleetAttributes.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> BUILD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuildId").getter(FleetAttributes.getter(FleetAttributes::buildId)).setter(FleetAttributes.setter(Builder::buildId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildId").build()}).build();
    private static final SdkField<String> BUILD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuildArn").getter(FleetAttributes.getter(FleetAttributes::buildArn)).setter(FleetAttributes.setter(Builder::buildArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildArn").build()}).build();
    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScriptId").getter(FleetAttributes.getter(FleetAttributes::scriptId)).setter(FleetAttributes.setter(Builder::scriptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()}).build();
    private static final SdkField<String> SCRIPT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScriptArn").getter(FleetAttributes.getter(FleetAttributes::scriptArn)).setter(FleetAttributes.setter(Builder::scriptArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptArn").build()}).build();
    private static final SdkField<String> SERVER_LAUNCH_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerLaunchPath").getter(FleetAttributes.getter(FleetAttributes::serverLaunchPath)).setter(FleetAttributes.setter(Builder::serverLaunchPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchPath").build()}).build();
    private static final SdkField<String> SERVER_LAUNCH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerLaunchParameters").getter(FleetAttributes.getter(FleetAttributes::serverLaunchParameters)).setter(FleetAttributes.setter(Builder::serverLaunchParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchParameters").build()}).build();
    private static final SdkField<List<String>> LOG_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogPaths").getter(FleetAttributes.getter(FleetAttributes::logPaths)).setter(FleetAttributes.setter(Builder::logPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewGameSessionProtectionPolicy").getter(FleetAttributes.getter(FleetAttributes::newGameSessionProtectionPolicyAsString)).setter(FleetAttributes.setter(Builder::newGameSessionProtectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(FleetAttributes.getter(FleetAttributes::operatingSystemAsString)).setter(FleetAttributes.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<ResourceCreationLimitPolicy> RESOURCE_CREATION_LIMIT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCreationLimitPolicy").getter(FleetAttributes.getter(FleetAttributes::resourceCreationLimitPolicy)).setter(FleetAttributes.setter(Builder::resourceCreationLimitPolicy)).constructor(ResourceCreationLimitPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCreationLimitPolicy").build()}).build();
    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricGroups").getter(FleetAttributes.getter(FleetAttributes::metricGroups)).setter(FleetAttributes.setter(Builder::metricGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STOPPED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StoppedActions").getter(FleetAttributes.getter(FleetAttributes::stoppedActionsAsStrings)).setter(FleetAttributes.setter(Builder::stoppedActionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppedActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceRoleArn").getter(FleetAttributes.getter(FleetAttributes::instanceRoleArn)).setter(FleetAttributes.setter(Builder::instanceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRoleArn").build()}).build();
    private static final SdkField<CertificateConfiguration> CERTIFICATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CertificateConfiguration").getter(FleetAttributes.getter(FleetAttributes::certificateConfiguration)).setter(FleetAttributes.setter(Builder::certificateConfiguration)).constructor(CertificateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, FLEET_TYPE_FIELD, INSTANCE_TYPE_FIELD, DESCRIPTION_FIELD, NAME_FIELD, CREATION_TIME_FIELD, TERMINATION_TIME_FIELD, STATUS_FIELD, BUILD_ID_FIELD, BUILD_ARN_FIELD, SCRIPT_ID_FIELD, SCRIPT_ARN_FIELD, SERVER_LAUNCH_PATH_FIELD, SERVER_LAUNCH_PARAMETERS_FIELD, LOG_PATHS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD, OPERATING_SYSTEM_FIELD, RESOURCE_CREATION_LIMIT_POLICY_FIELD, METRIC_GROUPS_FIELD, STOPPED_ACTIONS_FIELD, INSTANCE_ROLE_ARN_FIELD, CERTIFICATE_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fleetId;
    private final String fleetArn;
    private final String fleetType;
    private final String instanceType;
    private final String description;
    private final String name;
    private final Instant creationTime;
    private final Instant terminationTime;
    private final String status;
    private final String buildId;
    private final String buildArn;
    private final String scriptId;
    private final String scriptArn;
    private final String serverLaunchPath;
    private final String serverLaunchParameters;
    private final List<String> logPaths;
    private final String newGameSessionProtectionPolicy;
    private final String operatingSystem;
    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;
    private final List<String> metricGroups;
    private final List<String> stoppedActions;
    private final String instanceRoleArn;
    private final CertificateConfiguration certificateConfiguration;

    private FleetAttributes(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.fleetType = builder.fleetType;
        this.instanceType = builder.instanceType;
        this.description = builder.description;
        this.name = builder.name;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.status = builder.status;
        this.buildId = builder.buildId;
        this.buildArn = builder.buildArn;
        this.scriptId = builder.scriptId;
        this.scriptArn = builder.scriptArn;
        this.serverLaunchPath = builder.serverLaunchPath;
        this.serverLaunchParameters = builder.serverLaunchParameters;
        this.logPaths = builder.logPaths;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.operatingSystem = builder.operatingSystem;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
        this.stoppedActions = builder.stoppedActions;
        this.instanceRoleArn = builder.instanceRoleArn;
        this.certificateConfiguration = builder.certificateConfiguration;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final FleetType fleetType() {
        return FleetType.fromValue(this.fleetType);
    }

    public final String fleetTypeAsString() {
        return this.fleetType;
    }

    public final EC2InstanceType instanceType() {
        return EC2InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant terminationTime() {
        return this.terminationTime;
    }

    public final FleetStatus status() {
        return FleetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String buildId() {
        return this.buildId;
    }

    public final String buildArn() {
        return this.buildArn;
    }

    public final String scriptId() {
        return this.scriptId;
    }

    public final String scriptArn() {
        return this.scriptArn;
    }

    public final String serverLaunchPath() {
        return this.serverLaunchPath;
    }

    public final String serverLaunchParameters() {
        return this.serverLaunchParameters;
    }

    public final boolean hasLogPaths() {
        return this.logPaths != null && !(this.logPaths instanceof SdkAutoConstructList);
    }

    public final List<String> logPaths() {
        return this.logPaths;
    }

    public final ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(this.newGameSessionProtectionPolicy);
    }

    public final String newGameSessionProtectionPolicyAsString() {
        return this.newGameSessionProtectionPolicy;
    }

    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return this.resourceCreationLimitPolicy;
    }

    public final boolean hasMetricGroups() {
        return this.metricGroups != null && !(this.metricGroups instanceof SdkAutoConstructList);
    }

    public final List<String> metricGroups() {
        return this.metricGroups;
    }

    public final List<FleetAction> stoppedActions() {
        return FleetActionListCopier.copyStringToEnum(this.stoppedActions);
    }

    public final boolean hasStoppedActions() {
        return this.stoppedActions != null && !(this.stoppedActions instanceof SdkAutoConstructList);
    }

    public final List<String> stoppedActionsAsStrings() {
        return this.stoppedActions;
    }

    public final String instanceRoleArn() {
        return this.instanceRoleArn;
    }

    public final CertificateConfiguration certificateConfiguration() {
        return this.certificateConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildId());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogPaths() ? this.logPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricGroups() ? this.metricGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStoppedActions() ? this.stoppedActionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetAttributes)) {
            return false;
        }
        FleetAttributes other = (FleetAttributes)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.fleetTypeAsString(), other.fleetTypeAsString()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.terminationTime(), other.terminationTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.buildId(), other.buildId()) && Objects.equals(this.buildArn(), other.buildArn()) && Objects.equals(this.scriptId(), other.scriptId()) && Objects.equals(this.scriptArn(), other.scriptArn()) && Objects.equals(this.serverLaunchPath(), other.serverLaunchPath()) && Objects.equals(this.serverLaunchParameters(), other.serverLaunchParameters()) && this.hasLogPaths() == other.hasLogPaths() && Objects.equals(this.logPaths(), other.logPaths()) && Objects.equals(this.newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.resourceCreationLimitPolicy(), other.resourceCreationLimitPolicy()) && this.hasMetricGroups() == other.hasMetricGroups() && Objects.equals(this.metricGroups(), other.metricGroups()) && this.hasStoppedActions() == other.hasStoppedActions() && Objects.equals(this.stoppedActionsAsStrings(), other.stoppedActionsAsStrings()) && Objects.equals(this.instanceRoleArn(), other.instanceRoleArn()) && Objects.equals(this.certificateConfiguration(), other.certificateConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"FleetAttributes").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("FleetType", (Object)this.fleetTypeAsString()).add("InstanceType", (Object)this.instanceTypeAsString()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("CreationTime", (Object)this.creationTime()).add("TerminationTime", (Object)this.terminationTime()).add("Status", (Object)this.statusAsString()).add("BuildId", (Object)this.buildId()).add("BuildArn", (Object)this.buildArn()).add("ScriptId", (Object)this.scriptId()).add("ScriptArn", (Object)this.scriptArn()).add("ServerLaunchPath", (Object)this.serverLaunchPath()).add("ServerLaunchParameters", (Object)this.serverLaunchParameters()).add("LogPaths", this.hasLogPaths() ? this.logPaths() : null).add("NewGameSessionProtectionPolicy", (Object)this.newGameSessionProtectionPolicyAsString()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("ResourceCreationLimitPolicy", (Object)this.resourceCreationLimitPolicy()).add("MetricGroups", this.hasMetricGroups() ? this.metricGroups() : null).add("StoppedActions", this.hasStoppedActions() ? this.stoppedActionsAsStrings() : null).add("InstanceRoleArn", (Object)this.instanceRoleArn()).add("CertificateConfiguration", (Object)this.certificateConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "FleetType": {
                return Optional.ofNullable(clazz.cast(this.fleetTypeAsString()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TerminationTime": {
                return Optional.ofNullable(clazz.cast(this.terminationTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "BuildId": {
                return Optional.ofNullable(clazz.cast(this.buildId()));
            }
            case "BuildArn": {
                return Optional.ofNullable(clazz.cast(this.buildArn()));
            }
            case "ScriptId": {
                return Optional.ofNullable(clazz.cast(this.scriptId()));
            }
            case "ScriptArn": {
                return Optional.ofNullable(clazz.cast(this.scriptArn()));
            }
            case "ServerLaunchPath": {
                return Optional.ofNullable(clazz.cast(this.serverLaunchPath()));
            }
            case "ServerLaunchParameters": {
                return Optional.ofNullable(clazz.cast(this.serverLaunchParameters()));
            }
            case "LogPaths": {
                return Optional.ofNullable(clazz.cast(this.logPaths()));
            }
            case "NewGameSessionProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.newGameSessionProtectionPolicyAsString()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "ResourceCreationLimitPolicy": {
                return Optional.ofNullable(clazz.cast(this.resourceCreationLimitPolicy()));
            }
            case "MetricGroups": {
                return Optional.ofNullable(clazz.cast(this.metricGroups()));
            }
            case "StoppedActions": {
                return Optional.ofNullable(clazz.cast(this.stoppedActionsAsStrings()));
            }
            case "InstanceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.instanceRoleArn()));
            }
            case "CertificateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.certificateConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetAttributes, T> g) {
        return obj -> g.apply((FleetAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String fleetType;
        private String instanceType;
        private String description;
        private String name;
        private Instant creationTime;
        private Instant terminationTime;
        private String status;
        private String buildId;
        private String buildArn;
        private String scriptId;
        private String scriptArn;
        private String serverLaunchPath;
        private String serverLaunchParameters;
        private List<String> logPaths = DefaultSdkAutoConstructList.getInstance();
        private String newGameSessionProtectionPolicy;
        private String operatingSystem;
        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;
        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> stoppedActions = DefaultSdkAutoConstructList.getInstance();
        private String instanceRoleArn;
        private CertificateConfiguration certificateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetAttributes model) {
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.fleetType(model.fleetType);
            this.instanceType(model.instanceType);
            this.description(model.description);
            this.name(model.name);
            this.creationTime(model.creationTime);
            this.terminationTime(model.terminationTime);
            this.status(model.status);
            this.buildId(model.buildId);
            this.buildArn(model.buildArn);
            this.scriptId(model.scriptId);
            this.scriptArn(model.scriptArn);
            this.serverLaunchPath(model.serverLaunchPath);
            this.serverLaunchParameters(model.serverLaunchParameters);
            this.logPaths(model.logPaths);
            this.newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            this.operatingSystem(model.operatingSystem);
            this.resourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            this.metricGroups(model.metricGroups);
            this.stoppedActionsWithStrings(model.stoppedActions);
            this.instanceRoleArn(model.instanceRoleArn);
            this.certificateConfiguration(model.certificateConfiguration);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        @Transient
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        @Transient
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getFleetType() {
            return this.fleetType;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        @Override
        @Transient
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        @Transient
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType == null ? null : fleetType.toString());
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceType(EC2InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getTerminationTime() {
            return this.terminationTime;
        }

        public final void setTerminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
        }

        @Override
        @Transient
        public final Builder terminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(FleetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getBuildId() {
            return this.buildId;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        @Override
        @Transient
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final String getBuildArn() {
            return this.buildArn;
        }

        public final void setBuildArn(String buildArn) {
            this.buildArn = buildArn;
        }

        @Override
        @Transient
        public final Builder buildArn(String buildArn) {
            this.buildArn = buildArn;
            return this;
        }

        public final String getScriptId() {
            return this.scriptId;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        @Override
        @Transient
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final String getScriptArn() {
            return this.scriptArn;
        }

        public final void setScriptArn(String scriptArn) {
            this.scriptArn = scriptArn;
        }

        @Override
        @Transient
        public final Builder scriptArn(String scriptArn) {
            this.scriptArn = scriptArn;
            return this;
        }

        public final String getServerLaunchPath() {
            return this.serverLaunchPath;
        }

        public final void setServerLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
        }

        @Override
        @Transient
        public final Builder serverLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
            return this;
        }

        public final String getServerLaunchParameters() {
            return this.serverLaunchParameters;
        }

        public final void setServerLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
        }

        @Override
        @Transient
        public final Builder serverLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
            return this;
        }

        public final Collection<String> getLogPaths() {
            if (this.logPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logPaths;
        }

        public final void setLogPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
        }

        @Override
        @Transient
        public final Builder logPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logPaths(String ... logPaths) {
            this.logPaths(Arrays.asList(logPaths));
            return this;
        }

        public final String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        @Override
        @Transient
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        @Transient
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy.toString());
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        @Transient
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        @Transient
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final ResourceCreationLimitPolicy.Builder getResourceCreationLimitPolicy() {
            return this.resourceCreationLimitPolicy != null ? this.resourceCreationLimitPolicy.toBuilder() : null;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy.BuilderImpl resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final Collection<String> getMetricGroups() {
            if (this.metricGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricGroups;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @Override
        @Transient
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricGroups(String ... metricGroups) {
            this.metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final Collection<String> getStoppedActions() {
            if (this.stoppedActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stoppedActions;
        }

        public final void setStoppedActions(Collection<String> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copy(stoppedActions);
        }

        @Override
        @Transient
        public final Builder stoppedActionsWithStrings(Collection<String> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copy(stoppedActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stoppedActionsWithStrings(String ... stoppedActions) {
            this.stoppedActionsWithStrings(Arrays.asList(stoppedActions));
            return this;
        }

        @Override
        @Transient
        public final Builder stoppedActions(Collection<FleetAction> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copyEnumToString(stoppedActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stoppedActions(FleetAction ... stoppedActions) {
            this.stoppedActions(Arrays.asList(stoppedActions));
            return this;
        }

        public final String getInstanceRoleArn() {
            return this.instanceRoleArn;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        @Override
        @Transient
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        public final CertificateConfiguration.Builder getCertificateConfiguration() {
            return this.certificateConfiguration != null ? this.certificateConfiguration.toBuilder() : null;
        }

        public final void setCertificateConfiguration(CertificateConfiguration.BuilderImpl certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration != null ? certificateConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder certificateConfiguration(CertificateConfiguration certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration;
            return this;
        }

        public FleetAttributes build() {
            return new FleetAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetAttributes> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder fleetType(String var1);

        public Builder fleetType(FleetType var1);

        public Builder instanceType(String var1);

        public Builder instanceType(EC2InstanceType var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder creationTime(Instant var1);

        public Builder terminationTime(Instant var1);

        public Builder status(String var1);

        public Builder status(FleetStatus var1);

        public Builder buildId(String var1);

        public Builder buildArn(String var1);

        public Builder scriptId(String var1);

        public Builder scriptArn(String var1);

        public Builder serverLaunchPath(String var1);

        public Builder serverLaunchParameters(String var1);

        public Builder logPaths(Collection<String> var1);

        public Builder logPaths(String ... var1);

        public Builder newGameSessionProtectionPolicy(String var1);

        public Builder newGameSessionProtectionPolicy(ProtectionPolicy var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy var1);

        default public Builder resourceCreationLimitPolicy(Consumer<ResourceCreationLimitPolicy.Builder> resourceCreationLimitPolicy) {
            return this.resourceCreationLimitPolicy((ResourceCreationLimitPolicy)((ResourceCreationLimitPolicy.Builder)ResourceCreationLimitPolicy.builder().applyMutation(resourceCreationLimitPolicy)).build());
        }

        public Builder metricGroups(Collection<String> var1);

        public Builder metricGroups(String ... var1);

        public Builder stoppedActionsWithStrings(Collection<String> var1);

        public Builder stoppedActionsWithStrings(String ... var1);

        public Builder stoppedActions(Collection<FleetAction> var1);

        public Builder stoppedActions(FleetAction ... var1);

        public Builder instanceRoleArn(String var1);

        public Builder certificateConfiguration(CertificateConfiguration var1);

        default public Builder certificateConfiguration(Consumer<CertificateConfiguration.Builder> certificateConfiguration) {
            return this.certificateConfiguration((CertificateConfiguration)((CertificateConfiguration.Builder)CertificateConfiguration.builder().applyMutation(certificateConfiguration)).build());
        }
    }
}

