/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.MatchmakingIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMatchmakingRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DescribeMatchmakingRequest> {
    private static final SdkField<List<String>> TICKET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TicketIds").getter(DescribeMatchmakingRequest.getter(DescribeMatchmakingRequest::ticketIds)).setter(DescribeMatchmakingRequest.setter(Builder::ticketIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_IDS_FIELD));
    private final List<String> ticketIds;

    private DescribeMatchmakingRequest(BuilderImpl builder) {
        super(builder);
        this.ticketIds = builder.ticketIds;
    }

    public final boolean hasTicketIds() {
        return this.ticketIds != null && !(this.ticketIds instanceof SdkAutoConstructList);
    }

    public final List<String> ticketIds() {
        return this.ticketIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTicketIds() ? this.ticketIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingRequest)) {
            return false;
        }
        DescribeMatchmakingRequest other = (DescribeMatchmakingRequest)((Object)obj);
        return this.hasTicketIds() == other.hasTicketIds() && Objects.equals(this.ticketIds(), other.ticketIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMatchmakingRequest").add("TicketIds", this.hasTicketIds() ? this.ticketIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TicketIds": {
                return Optional.ofNullable(clazz.cast(this.ticketIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMatchmakingRequest, T> g) {
        return obj -> g.apply((DescribeMatchmakingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private List<String> ticketIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingRequest model) {
            super(model);
            this.ticketIds(model.ticketIds);
        }

        public final Collection<String> getTicketIds() {
            if (this.ticketIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ticketIds;
        }

        public final void setTicketIds(Collection<String> ticketIds) {
            this.ticketIds = MatchmakingIdListCopier.copy(ticketIds);
        }

        @Override
        @Transient
        public final Builder ticketIds(Collection<String> ticketIds) {
            this.ticketIds = MatchmakingIdListCopier.copy(ticketIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ticketIds(String ... ticketIds) {
            this.ticketIds(Arrays.asList(ticketIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMatchmakingRequest build() {
            return new DescribeMatchmakingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMatchmakingRequest> {
        public Builder ticketIds(Collection<String> var1);

        public Builder ticketIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

