/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.PlayerSession;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlayerSessionsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, CreatePlayerSessionsResponse> {
    private static final SdkField<List<PlayerSession>> PLAYER_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlayerSessions").getter(CreatePlayerSessionsResponse.getter(CreatePlayerSessionsResponse::playerSessions)).setter(CreatePlayerSessionsResponse.setter(Builder::playerSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlayerSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAYER_SESSIONS_FIELD));
    private final List<PlayerSession> playerSessions;

    private CreatePlayerSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.playerSessions = builder.playerSessions;
    }

    public final boolean hasPlayerSessions() {
        return this.playerSessions != null && !(this.playerSessions instanceof SdkAutoConstructList);
    }

    public final List<PlayerSession> playerSessions() {
        return this.playerSessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlayerSessions() ? this.playerSessions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionsResponse)) {
            return false;
        }
        CreatePlayerSessionsResponse other = (CreatePlayerSessionsResponse)((Object)obj);
        return this.hasPlayerSessions() == other.hasPlayerSessions() && Objects.equals(this.playerSessions(), other.playerSessions());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePlayerSessionsResponse").add("PlayerSessions", this.hasPlayerSessions() ? this.playerSessions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerSessions": {
                return Optional.ofNullable(clazz.cast(this.playerSessions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlayerSessionsResponse, T> g) {
        return obj -> g.apply((CreatePlayerSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<PlayerSession> playerSessions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlayerSessionsResponse model) {
            super(model);
            this.playerSessions(model.playerSessions);
        }

        public final List<PlayerSession.Builder> getPlayerSessions() {
            List<PlayerSession.Builder> result = PlayerSessionListCopier.copyToBuilder(this.playerSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlayerSessions(Collection<PlayerSession.BuilderImpl> playerSessions) {
            this.playerSessions = PlayerSessionListCopier.copyFromBuilder(playerSessions);
        }

        @Override
        @Transient
        public final Builder playerSessions(Collection<PlayerSession> playerSessions) {
            this.playerSessions = PlayerSessionListCopier.copy(playerSessions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder playerSessions(PlayerSession ... playerSessions) {
            this.playerSessions(Arrays.asList(playerSessions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder playerSessions(Consumer<PlayerSession.Builder> ... playerSessions) {
            this.playerSessions(Stream.of(playerSessions).map(c -> (PlayerSession)((PlayerSession.Builder)PlayerSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreatePlayerSessionsResponse build() {
            return new CreatePlayerSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePlayerSessionsResponse> {
        public Builder playerSessions(Collection<PlayerSession> var1);

        public Builder playerSessions(PlayerSession ... var1);

        public Builder playerSessions(Consumer<PlayerSession.Builder> ... var1);
    }
}

