/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueue;

public class DescribeGameSessionQueuesPublisher
implements SdkPublisher<DescribeGameSessionQueuesResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeGameSessionQueuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeGameSessionQueuesPublisher(GameLiftAsyncClient client, DescribeGameSessionQueuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeGameSessionQueuesPublisher(GameLiftAsyncClient client, DescribeGameSessionQueuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeGameSessionQueuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeGameSessionQueuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GameSessionQueue> gameSessionQueues() {
        Function<DescribeGameSessionQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameSessionQueues() != null) {
                return response.gameSessionQueues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeGameSessionQueuesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeGameSessionQueuesResponseFetcher
    implements AsyncPageFetcher<DescribeGameSessionQueuesResponse> {
        private DescribeGameSessionQueuesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGameSessionQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeGameSessionQueuesResponse> nextPage(DescribeGameSessionQueuesResponse previousPage) {
            if (previousPage == null) {
                return DescribeGameSessionQueuesPublisher.this.client.describeGameSessionQueues(DescribeGameSessionQueuesPublisher.this.firstRequest);
            }
            return DescribeGameSessionQueuesPublisher.this.client.describeGameSessionQueues((DescribeGameSessionQueuesRequest)((Object)DescribeGameSessionQueuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

