/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlayerSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlayerSession> {
    private static final SdkField<String> PLAYER_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerSessionId").getter(PlayerSession.getter(PlayerSession::playerSessionId)).setter(PlayerSession.setter(Builder::playerSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessionId").build()}).build();
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerId").getter(PlayerSession.getter(PlayerSession::playerId)).setter(PlayerSession.setter(Builder::playerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()}).build();
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionId").getter(PlayerSession.getter(PlayerSession::gameSessionId)).setter(PlayerSession.setter(Builder::gameSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(PlayerSession.getter(PlayerSession::fleetId)).setter(PlayerSession.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(PlayerSession.getter(PlayerSession::fleetArn)).setter(PlayerSession.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(PlayerSession.getter(PlayerSession::creationTime)).setter(PlayerSession.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TERMINATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TerminationTime").getter(PlayerSession.getter(PlayerSession::terminationTime)).setter(PlayerSession.setter(Builder::terminationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PlayerSession.getter(PlayerSession::statusAsString)).setter(PlayerSession.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(PlayerSession.getter(PlayerSession::ipAddress)).setter(PlayerSession.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(PlayerSession.getter(PlayerSession::dnsName)).setter(PlayerSession.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(PlayerSession.getter(PlayerSession::port)).setter(PlayerSession.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> PLAYER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerData").getter(PlayerSession.getter(PlayerSession::playerData)).setter(PlayerSession.setter(Builder::playerData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAYER_SESSION_ID_FIELD, PLAYER_ID_FIELD, GAME_SESSION_ID_FIELD, FLEET_ID_FIELD, FLEET_ARN_FIELD, CREATION_TIME_FIELD, TERMINATION_TIME_FIELD, STATUS_FIELD, IP_ADDRESS_FIELD, DNS_NAME_FIELD, PORT_FIELD, PLAYER_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String playerSessionId;
    private final String playerId;
    private final String gameSessionId;
    private final String fleetId;
    private final String fleetArn;
    private final Instant creationTime;
    private final Instant terminationTime;
    private final String status;
    private final String ipAddress;
    private final String dnsName;
    private final Integer port;
    private final String playerData;

    private PlayerSession(BuilderImpl builder) {
        this.playerSessionId = builder.playerSessionId;
        this.playerId = builder.playerId;
        this.gameSessionId = builder.gameSessionId;
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.status = builder.status;
        this.ipAddress = builder.ipAddress;
        this.dnsName = builder.dnsName;
        this.port = builder.port;
        this.playerData = builder.playerData;
    }

    public final String playerSessionId() {
        return this.playerSessionId;
    }

    public final String playerId() {
        return this.playerId;
    }

    public final String gameSessionId() {
        return this.gameSessionId;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant terminationTime() {
        return this.terminationTime;
    }

    public final PlayerSessionStatus status() {
        return PlayerSessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final Integer port() {
        return this.port;
    }

    public final String playerData() {
        return this.playerData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerSession)) {
            return false;
        }
        PlayerSession other = (PlayerSession)obj;
        return Objects.equals(this.playerSessionId(), other.playerSessionId()) && Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.terminationTime(), other.terminationTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.playerData(), other.playerData());
    }

    public final String toString() {
        return ToString.builder((String)"PlayerSession").add("PlayerSessionId", (Object)this.playerSessionId()).add("PlayerId", (Object)this.playerId()).add("GameSessionId", (Object)this.gameSessionId()).add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("CreationTime", (Object)this.creationTime()).add("TerminationTime", (Object)this.terminationTime()).add("Status", (Object)this.statusAsString()).add("IpAddress", (Object)this.ipAddress()).add("DnsName", (Object)this.dnsName()).add("Port", (Object)this.port()).add("PlayerData", (Object)this.playerData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerSessionId": {
                return Optional.ofNullable(clazz.cast(this.playerSessionId()));
            }
            case "PlayerId": {
                return Optional.ofNullable(clazz.cast(this.playerId()));
            }
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TerminationTime": {
                return Optional.ofNullable(clazz.cast(this.terminationTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "PlayerData": {
                return Optional.ofNullable(clazz.cast(this.playerData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlayerSession, T> g) {
        return obj -> g.apply((PlayerSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String playerSessionId;
        private String playerId;
        private String gameSessionId;
        private String fleetId;
        private String fleetArn;
        private Instant creationTime;
        private Instant terminationTime;
        private String status;
        private String ipAddress;
        private String dnsName;
        private Integer port;
        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayerSession model) {
            this.playerSessionId(model.playerSessionId);
            this.playerId(model.playerId);
            this.gameSessionId(model.gameSessionId);
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.creationTime(model.creationTime);
            this.terminationTime(model.terminationTime);
            this.status(model.status);
            this.ipAddress(model.ipAddress);
            this.dnsName(model.dnsName);
            this.port(model.port);
            this.playerData(model.playerData);
        }

        public final String getPlayerSessionId() {
            return this.playerSessionId;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        @Override
        @Transient
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        @Override
        @Transient
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        @Transient
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        @Transient
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        @Transient
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getTerminationTime() {
            return this.terminationTime;
        }

        public final void setTerminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
        }

        @Override
        @Transient
        public final Builder terminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(PlayerSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        @Transient
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        @Transient
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getPlayerData() {
            return this.playerData;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        @Override
        @Transient
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        public PlayerSession build() {
            return new PlayerSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlayerSession> {
        public Builder playerSessionId(String var1);

        public Builder playerId(String var1);

        public Builder gameSessionId(String var1);

        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder terminationTime(Instant var1);

        public Builder status(String var1);

        public Builder status(PlayerSessionStatus var1);

        public Builder ipAddress(String var1);

        public Builder dnsName(String var1);

        public Builder port(Integer var1);

        public Builder playerData(String var1);
    }
}

